# usage: [carmel exec] perl geo_stream.pl [-s] [-d 300] -f <log_file_name>

use 5.34.0;
use lib '.';
use GeoStream;
use Getopt::Long;

use utf8;
use open ':std', ':utf8';

my $deduct_time = 0; # time in seconds to deduct from log timestamps
my $simulation  = 0; # if set, will simulate real-time delays based on log timestamps

GetOptions(
	'simulation|s'     => \$simulation,
	'file|f=s'         => \my $file,
	'test|t'           => \my $test,
	'sql_trace|q'      => \my $sql_trace,
	'deduct-time|d=i'  => \$deduct_time,
);

my $geo = GeoStream->new(
	deduct_time => $deduct_time,
	simulation  => $simulation,
	test_output => $test,
	sql_trace   => $sql_trace,
);

open my $fh, '<', $file or die "Can't open $file: $!"; # warn $file;
while (<$fh>) { # say $_;
	$geo->decode_line($_);
}
