#===============================================================================
# why D2::Session::Simple sessions don't work propely with Starman

# Using sessions with perl Dancer/plack/Starman and multiple workers
# https://stackoverflow.com/questions/28920848/using-sessions-with-perl-dancer-plack-starman-and-multiple-workers
#===============================================================================

##  plackup sessiontest.pl -p 3000 -s Twiggy/Gazelle [or Starman --workers=3]

# Twiggy works OK, Gazelle doesn't increment counter at all, Starman increments
# counter OK for delay between reloads of around 1 sec or less

use Dancer2;

get '/sessiontest' => sub {
    my $testcounter = session 'testcounter' || 0;
    $testcounter++;
    info 'SESSION COUNTER = ' . $testcounter;
    session testcounter => $testcounter;
    my $pid = $$; # p $pid;

    return qq!
      <html>
      <body>
        <a style="color: #00f; text-decoration: none"
            href="/sessiontest">counter: $testcounter [pid:$pid]</a>
            &#171; click to reload
      </body>
      </html>!;
};

dance;
