#===============================================================================
# why D2::Session::Simple sessions don't work propely with Starman

# Using sessions with perl Dancer/plack/Starman and multiple workers
# https://stackoverflow.com/questions/28920848/using-sessions-with-perl-dancer-plack-starman-and-multiple-workers
#===============================================================================

##  plackup sessiontest.pl -p 3000 -s Twiggy [Starman --workers=3]

# for Starman, delay between reloads around 1 sec or less, counter increments OK

use Dancer2;

get '/sessiontest' => sub {
    my $testcounter = session 'testcounter' || 0;
    $testcounter++;
    session testcounter => $testcounter;
    info 'SESSION COUNTER = ' . $testcounter;

    return qq!
      <html>
      <body>
        <a style="color: #00f; text-decoration: none"
            href="/sessiontest">click to reload &#187; $testcounter</a>
      </body>
      </html>!;
};

dance;
