#!/usr/bin/env perl

# starts the plackup -s Starman/Twiggy/Gazelle/Starlet -a bin/app.psgi process
# init.d script needs PERL5LIB env var set so plackup can find Plack::Runner
# to start service at boot: sudo update-rc.d rwgps defaults
# see below for init.d text

# this does not work using socket - if run as user raj, lighttpd (www-data)
# cannot access socket as Starman sets it to 755, and if run as www-data,
# have permission problems on socket & FastMmap cache file in
# /tmp/chi-driver-fastmmap dir # (.)(.)

use warnings;
use strict;

use lib '/home/raj/perl5/lib/perl5';
use Daemon::Control;
use Plack::Runner; # only needed if using direct in program sub
use Data::Printer;

# use FindBin qw($Bin);  # load AFTER local::lib Carp or FindBin loads system Carp

my $GROUP  = $ENV{APP_GROUP} || die 'no APP_GROUP env var set'; # warn $GROUP;
my $USER   = $ENV{APP_USER}  || die 'no APP_USER env var set';  # warn $USER;

my $run_dir  = '/var/run'; # location of pid file & stderr
my $app_home = '/home/raj/apps/SessionTest';
my $plackup  = '/home/raj/perl5/bin/plackup';
my $server   = '/home/raj/perl5/bin/starman';
my $pid_file = $run_dir . '/sessiontest.pid';
my $workers  = 3;
my $stdout   = $app_home . '/logs/deployment.log';
my $stderr 	 = $stdout; # combined
my $socket   = '/tmp/sessiontest.sock';
my $port     = 5001;
my $name     = 'SessionTest';
my $app      = 'app.psgi';

my @program_args = (
	-s => 'Gazelle', # Twiggy/Starman/Starlet
	-a => "$app_home/bin/$app",
	# -l => $socket, # problematic - see preable above
    -p => $port, # doesn't work if socket also enabled
	-E => 'deployment', # tells dancer app which env & logs to use
	# '--workers' => $workers,
);

my %args = (
    name         => $name,
#   lsb_start   => '$syslog $remote_fs',
#   lsb_stop    => '$syslog',
    lsb_sdesc    => $name,
    lsb_desc     => $name,
    path         => $0, # this script
    # program      => $plackup,
    program      => \&program, # uses Plack::Runner direct
    program_args => \@program_args,

    pid_file     => $pid_file,
    stderr_file  => $stderr,
    stdout_file  => $stdout,

	user         => $USER,
    group        => $GROUP,
    fork         => 2,
); # warn Dumper \%args;

exit Daemon::Control->new(\%args)->run;
# this never runs, but need to set socket to writable by www-data:
# chmod 0777, $socket;

sub program {
    # set PERL5LIB otherwise it can't find Plack::Runner (and probably others)
    $ENV{PERL5LIB} = '/home/raj/perl5/lib/perl5:/home/raj/perl-lib';

	my $runner = Plack::Runner->new;
	$runner->parse_options(@program_args);
	$runner->run;
}

=begin # alternative method, uses starman executable diretly:
sub program {
    $ENV{PERL5LIB} = '/home/raj/perl5/lib/perl5:/home/raj/perl-lib';
    my @args = (
        -a => $app,
        # -l => '/tmp/sessiontest.sock',
        -p => $port,
        '--workers' => $workers, # default is 5
    #   -E => 'deployment',    # automatically set for starman
    );
    exec($server, @args);
}
=cut

__DATA__
#!/bin/sh

### BEGIN INIT INFO
# Provides: 		SessionTest
# Required-Start:
# Required-Stop:
# Default-Start: 	2 3 4 5
# Default-Stop: 	0 1 6
# Short-Description: 	SessionTest daemon
# Description: 		Controls the sessiontest daemon script
### END INIT INFO

export APP_USER=raj
export APP_GROUP=raj
# so plackup can find Plack::Runner:
export PERL5LIB=/home/raj/perl5/lib/perl5

SCRIPT_DIR=/home/raj/apps/SessionTest/bin
SCRIPT=sessiontest.pl
if [ -x $SCRIPT_DIR/$SCRIPT ];
then
    /usr/bin/perl $SCRIPT_DIR/$SCRIPT $@
else
    echo "Required program $SCRIPT_DIR/$SCRIPT not found!"
    exit 1;
fi

