#!/usr/bin/env perl

use strict;
use warnings;
use FindBin '$Bin';
use lib "$Bin/../lib";

use Path::Tiny;
use SessionTest;
use Data::Printer;

# check we have a sessions & logs dir:
for my $dir( qw/logs sessions/ ) {
    my $path = path($Bin, '/../', $dir)->realpath; # warn $path;
    -e $path or warn "required directory '$path' is missing"; # no need for fatals
}

# use this block if you don't need middleware, and only have a single target Dancer app to run here
# SessionTest->to_app;

#=begin comment
# use this block if you want to include middleware such as Plack::Middleware::Deflater

use CHI;
use YAML;
use Plack::Builder;
# use Plack::App::Directory;
use Plack::Session::Store::File;
use Plack::Session::Store::Cache;

builder { # p %ENV;
	# mount "/css" => Plack::App::Directory->new({ root => "public/css" })->to_app;
    enable 'Debug' if $ENV{PLACK_ENV} eq 'development';
	enable 'Static', # this works for stand-alone plackup but not lighttp proxy due to path:
        path => qr{^/(images|javascripts|css)/}, root => 'public/';
	enable 'Session', 
		store => Plack::Session::Store::Cache->new(
            cache => CHI->new(driver => 'FastMmap', dir_create_mode => 0777)
        );
		#store => Plack::Session::Store::File->new(
        #    dir => $FindBin::Bin . '/../sessions',
            # default serializer = Storable; YAML takes it's args the opposite order
        #    serializer   => sub { YAML::DumpFile( reverse @_ ) },
        #    deserializer => sub { YAML::LoadFile( @_ ) },
        # ;
    SessionTest->to_app;
}

#=end comment

=cut

=begin comment
# use this block if you want to mount several applications on different path

use SessionTest;
use SessionTest_admin;

use Plack::Builder;

builder {
    mount '/'      => SessionTest->to_app;
    mount '/admin' => SessionTest_admin->to_app;
}

=end comment

=cut

