use 5.24.0;

# tests plack servers with SessionTest app; use 'PLACK_ENV=test' to load test.yml
# to suppress debug output, or omit for verbose output; call test script as:
#  env [PLACK_ENV=test] PLACK_SERVER=Starman/Gazelle/Starlet/Twiggy prove -lv t/

#### watch PID in console output, sometimes varies, sometimes doesn't, but never
#### increments counter

use Test::More;
use Plack::Test;
use Data::Printer;
use Plack::Request;
use HTTP::Request::Common;
use Term::ANSIColor::Simple;

use constant TESTS => 10;

if ( $ENV{PLACK_SERVER} ) {
	warn '=' x 37 . "\n"; # unlike 'say', warn outputs even without -v flag
	warn "\trunning tests using $ENV{PLACK_SERVER} server\n";
	warn '=' x 50 . "\n";
}
else {
	die 'usage: env PLACK_SERVER=Starman/Gazelle/Starlet/Twiggy/PSGI '
		. "prove -lv t/myapp.t\n";
}

{
    package MyApp;
    use Dancer2;
    use Data::Printer;
    use Term::ANSIColor::Simple;

    my $c = config;
	$c->{engines}->{session}->{Cookie}->{secret_key} = 'blabenshpule'; # p $c;
	# set session => 'Cookie'; # doesn't fix failure to increment
	set session => 'PSGI';     # doesn't fix failure to increment

    get '/' => sub { # same logic as sessiontest.pl
        my $session = session(); # p $session;
        my $testcounter = session 'testcounter' || 0;
        $testcounter++;
      # this should increment but doesn't:
        say color("SESSION COUNTER = $testcounter")->yellow;
        session testcounter => $testcounter; # p $session;
        my $pid = $$;
        return "counter: $testcounter; pid: $pid";
    };
}

$Plack::Test::Impl = 'Server';

my $test = Plack::Test->create( MyApp->to_app );

# this gets a new session on each request - but needs to retain same one:
for (1 .. 5) {
    my $res = $test->request( GET '/' ); # say $res->header('Server');
        # say join ':', $_, $res->header($_) for $res->header_field_names;
    ok( $res->is_success, 'successful request' );
  # this should increment but doesn't, PID is different for each request:
    like $res->content, qr/counter: 1/, # qr/counter: $_/,
        sprintf 'expected content [%s]', $res->content;
}

done_testing(TESTS);
