#===============================================================================
# why D2::Session::Simple sessions don't work propely with Starman

# Using sessions with perl Dancer/plack/Starman and multiple workers
# https://stackoverflow.com/questions/28920848/using-sessions-with-perl-dancer-plack-starman-and-multiple-workers
#===============================================================================

##  plackup sessiontest.pl -r -p 3000 [-s Twiggy/Gazelle/Starman/Starlet]

# Twiggy and default HTTP::Server::PSGI work OK, Gazelle & Starlet don't
# increment counter at all, Starman increments counter OK for delay between
# reloads of around 1 sec or less

#### watch session ID change, or not, depending on server type, in console output

use Dancer2;
use Data::Printer;

get '/sessiontest' => sub {
    my $testcounter = session 'testcounter' || 0;
    $testcounter++;
    p my $id = 'session id=' . session->id;
    info 'SESSION COUNTER = ' . $testcounter;
    session testcounter => $testcounter; # p my $s = session;
    my $pid = $$; # p $pid;

    return qq!
      <html>
      <body>
        <a style="color: #00f; text-decoration: none"
            href="/sessiontest">counter: $testcounter [pid:$pid]</a>
            &#171; click to reload
      </body>
      </html>!;
};

dance;
