#!/usr/bin/env perl

use strict;
use warnings;
use FindBin;
use lib "$FindBin::Bin/../lib";

use SessionTest;

# use this block if you don't need middleware, and only have a single target Dancer app to run here
# SessionTest->to_app;

#=begin comment
# use this block if you want to include middleware such as Plack::Middleware::Deflater

use CHI;
use YAML;
use Plack::Builder;
use Plack::Session::Store::File;
use Plack::Session::Store::Cache;

builder {
    enable 'Debug';
	enable 'Session', 
		store => Plack::Session::Store::Cache->new(
            cache => CHI->new(driver => 'FastMmap')
        );
		#store => Plack::Session::Store::File->new(
        #    dir => $FindBin::Bin . '/../sessions',
            # default serializer = Storable; YAML takes it's args the opposite order
        #    serializer   => sub { YAML::DumpFile( reverse @_ ) },
        #    deserializer => sub { YAML::LoadFile( @_ ) },
        # ;
    SessionTest->to_app;
}

#=end comment

=cut

=begin comment
# use this block if you want to mount several applications on different path

use SessionTest;
use SessionTest_admin;

use Plack::Builder;

builder {
    mount '/'      => SessionTest->to_app;
    mount '/admin' => SessionTest_admin->to_app;
}

=end comment

=cut

