#===============================================================================
# why D2::Session::Simple sessions don't work propely with Starman

# Using sessions with perl Dancer/plack/Starman and multiple workers
# https://stackoverflow.com/questions/28920848/using-sessions-with-perl-dancer-plack-starman-and-multiple-workers
#===============================================================================

## plackup testcounter.pl -R testcounter.pl -s Gazelle -e 'enable Debug' -p 3001
## ab -n 10000 http://127.0.0.1:3000/

# Twiggy and default HTTP::Server::PSGI work OK, Gazelle & Starlet don't
# increment counter at all, Starman increments counter OK for delay between
# reloads of around 1 sec or less

#### watch session ID change, or not, depending on server type, in console output

use Dancer2;
use Data::Printer;
use Carp qw(longmess);

# CHI/FastMmap config:
config->{engines}->{session}->{CHI}->{driver} = 'FastMmap'; # defaults OK
# set session => 'Simple';
# set session => 'Cookie';
set session => 'CHI';

my $stack = longmess("Stack:"); # p $stack;
my ($server) = $stack =~ /Plack::Handler::(\w+)/; # supplied by all but Twiggy
$server	||= 'unknown';

get '/:action?' => sub {
	my $r = request; # p $r;
	my $action = route_parameters->get('action');
    my $testcounter = session 'testcounter' || 0;
	{ # p %ENV;
		no warnings 'uninitialized'; # action
		$testcounter = 0 if $action eq 'reset';
	}
    $testcounter++;
    # p my $id = 'session id=' . session->id;
    info 'SESSION COUNTER = ' . $testcounter;
    session testcounter => $testcounter; # p my $s = session;
    my $pid = $$; # p $pid;

    return qq!
      <html>
	  <head>
		<style>
			body { font-family: Verdana, sans-serif }
			.red { color: #f00 }
			a { color: #00f; text-decoration: none }
		</style>
	  </head>
      <body>
		<div>[Server: $server; pid: $pid] 
			<span class="red">counter: $testcounter</span>
			<a href="/">reload</a> :: <a href="/reset">reset</a> 
		</div>
      </body>
      </html>!;
};

dance;
