use Test::WWW::Mechanize::JSON;
use LWP::Protocol::PSGI;

use Test::More import => ['!pass']; # tests => 3;
use Test::Deep; # superhashof()

use Data::Printer alias => 'ddp';

use RequestForm::Test;
use RequestForm;

my $psgi_app = RequestForm::runner()->psgi_app;
LWP::Protocol::PSGI->register($psgi_app);

my $mech = Test::WWW::Mechanize::JSON->new;
my $args = form_tokens(); # warn $args;

# initialise session with form tokens:
$mech->get_ok("http://localhost/?$args");                 # print_output($mech);

# test location search (returns json):
$mech->get('http://localhost/ajax/autosuggest_location?ref_src=Newtown');
{
    my $ref = $mech->json_ok('OK: json response')
        or BAIL_OUT ddp $mech->response; # warn Dumper $ref;
    cmp_deeply(
        $ref->{results}->[0],
        superhashof( { value => 'Newtown General Infirmary', info => 'ABC01' } ),
        'OK: expected location details found',
    );
}

# test non-existent location search (returns json):
$mech->get('http://localhost/ajax/autosuggest_location?ref_src=noexist');
{
    my $ref = $mech->json_ok('OK: json response')
        or BAIL_OUT p $mech->response; # warn Dumper $ref;
    is( ref $ref->{results} => 'ARRAY', 'OK: have result' );
    is_deeply( $ref->{results}, [], 'OK: no location found' );
}

# test ajax nhs number validation (returns text string):
$mech->get('http://localhost/ajax/validate_nhs_number?nhs_number=1111111111');
$mech->content_is('OK', 'OK: valid NHS number passed');

# invalid nhs number (returns text string):
$mech->get('http://localhost/ajax/validate_nhs_number?nhs_number=1111111112');
$mech->content_is('invalid', 'OK: invalid NHS number failed');

done_testing;
