package RequestForm::Role::PDS;

use FindBin;
use Moo::Role;
use Data::Dumper::Concise;

# supplies local versions of LIMS::Controller::Roles::PatientDemographics methods:
#-------------------------------------------------------------------------------
sub get_session_data { shift->session->read('_pds_data') } # original assumed CGI::Session
sub session_store_hashref {
    my ($self, $data, $key_name) = @_;
    $self->session->write($key_name => $data);
}
sub require_proxy {
    shift->settings->{patient_demographic_service}->{pds_proxy} ? 1 : 0;
}
sub get_username { 'RequestForm' } # maybe better to use remote IP address
sub user_profile { { id => 99999 } } # can't use HILIS user.id
sub get_logfile { "$FindBin::Bin/../logs/sms.csv" }
sub messages { shift->settings->{patient_demographic_service}->{messages}  }
sub cfg      { shift->settings->{patient_demographic_service} }
#-------------------------------------------------------------------------------

1;