use Test::WWW::Mechanize;
use WWW::Mechanize::TreeBuilder;

use LWP::Protocol::PSGI;

use Test::More import => ['!pass']; # tests => 3;

use RequestForm::Test;
use RequestForm;

use Data::Printer alias => 'ddp';
use Clone qw(clone);
use YAML::Tiny;
use IO::All;

my $psgi_app = RequestForm::runner()->psgi_app;
LWP::Protocol::PSGI->register($psgi_app);

my $mech = Test::WWW::Mechanize->new;
WWW::Mechanize::TreeBuilder->meta->apply($mech);

my $args = form_tokens(); # warn $args;

my $config  = YAML::Tiny->read( 'config.yml' ) or die $!; # ddp $config;

my $patient = patient_data(); # ddp $patient;
my $data = $patient->[0]; # dpp $data;

# delete any row in lims_test.patients where nhs_number = $data->{nhs_number}:
my $dbix = Local::DB->dbix('lims_test');
$dbix->delete('patients', { nhs_number => $data->{nhs_number} });

# initialise session with form tokens:
$mech->get_ok("http://localhost/?$args");                 # print_output($mech);

# submit invalid nhs_number:
$mech->get('http://localhost/');                       # print_output($mech);
$mech->field(nhs_number => $data->{nhs_number} + 1);
$mech->submit_form();                                     # print_output($mech);
# p $mech->content( format => 'text' ); # span inside div:
$mech->text_contains('NHS number: invalid', 'OK: invalid nhs number detected');

# submit valid nhs_number:
$mech->get('http://localhost/');                       # print_output($mech);
$mech->field(nhs_number => $data->{nhs_number});
$mech->submit_form();                                     # print_output($mech);
$mech->has_tag(
    p => 'No matching patient details found',
    'OK: nhs number submitted, no matching details found',
);

# submit invalid data set:
{
    my $required = $config->[0]->{validation}->{required};

    # for each required field, clone data, delete key & test for validation failure:
    for my $field (@$required) { # warn $field; # next;
        next if $field eq 'location_name'; # tt uses location_id not name (ajax function)

        my $clone = clone($data); # dpp $clone;
        delete $clone->{$field};  # dpp $clone;
        
        $mech->post('http://localhost/', $clone);
            # io($FindBin::Bin . '/'.$field.'.htm')->print($mech->{content});
        $mech->has_tag(
            div => 'Missing',
            "OK: $field field missing",
        );
    }
}
{ # submit valid dataset:
    $mech->post('http://localhost/', $data);           # print_output($mech);
    $mech->has_tag_like(
        p => qr/Form passed validation/,
        'OK: validation passed',
    );
    
    # put _skip_pds back in (not retained in form):
    $mech->field( _skip_pds => 1 );
    $mech->submit_form();                                 # print_output($mech);

    ok(
       $mech->look_down(_tag => 'table', class => 'hbc'), # table class="hbc"
       'OK: has barcode table element',
    );
    
    {
        my $ref = uc( $data->{last_name} . substr($data->{first_name}, 0, 1) ); # ddp $ref;
        $mech->has_tag_like(
            td => qr/\d+$ref/,
            'OK: unique ref id found',
        );
    }    
}

done_testing;
