package RequestForm::BarCode;

use HTML::Barcode::Code93;
use HTML::Barcode::QRCode; # need QR code reader

use RequestForm::Class; # provides Moo, Local::MooX::Types & LIMS::Local::Debug::p
has reference => ( is => 'ro', isa => String, required => 1 );

sub create_2d_barcode {
    my $self = shift;
    
    my $ref = $self->reference;
    my $img = HTML::Barcode::Code93->new(bar_height => 20, text => $ref);
    return $img->render_barcode; # excludes css
}

sub create_3d_barcode {
    my $self = shift;
   
    my $ref = $self->reference;
    my $img = HTML::Barcode::QRCode->new(text => $ref);
    return $img->render_barcode; # excludes css
}

1;