package RequestForm::Test;

# imports lib paths, Modern::Perl, etc into t/ scripts

use Modern::Perl;

use Import::Into;
use Exporter ();
use FindBin; # warn $FindBin::Bin;
use lib (
    '/home/raj/perl-lib', # MooX::Types
    $FindBin::Bin . '/../../HILIS4/lib', # LLU
);
use LIMS::Local::Utils;

open my $fh, '>' . $FindBin::Bin . '/mech.htm' or die $!;

sub print_output {
    my $response = shift;
    print $fh $response->{content};  
}

sub form_tokens {
    my $key = LIMS::Local::Utils::today->ymd;
    my $enc = sub { LIMS::Local::Utils::encrypt(shift, $key) };    
    return sprintf 'c=%s;u=%s', &$enc('leeds'), &$enc('unknown'); # inactive guest
}

our @EXPORT = qw(print_output form_tokens);

sub import {
  Modern::Perl->import::into(1);
  Data::Dumper->import::into(1);
  Data::Printer->import::into(1);
  goto &Exporter::import;
}

1;