package RequestForm;

use Dancer2;

use RequestForm::DB;
use RequestForm::PDF;
use RequestForm::BarCode;
use RequestForm::Validate;
use RequestForm::Validate::Ajax;

use Data::Dumper::Concise;

our $VERSION = '0.1';

hook before => sub {
    my $vars = params;
    debug Dumper $vars if dancer_app->environment eq 'development';
};

hook before_template => sub {
    my $tokens = shift;

    $tokens->{params} = params; # feed query params back
    $tokens->{config} = config; # give tt access to config

    { # referral source autosuggest:
        my $uri = uri_for('/ajax/autosuggest_location'); # shouldn't need ajax prefix
        $tokens->{uri_for_autosuggest_location} = $uri;
    }
    { # nhs number ajax validation:
        my $uri = uri_for('/ajax/validate_nhs_number'); # shouldn't need ajax prefix
        $tokens->{uri_for_nhs_number_validation} = $uri;
    }
};

# default Dancer2 app index page:
get '/index' => sub { template 'index', {}, { layout => 'index' } };

# default route to load request form:
get '/' => sub { template 'web_form' };

# submitted request form:
post '/' => sub {
    my $vars = params; # warn Dumper $vars;

    my $validation = _validate($vars); # warn Dumper $validation; # href

    # if $validation has 'pass' key, save params to db & return PDF to print:  
    if ( $validation->{pass} ) { # no validation errors
        my $data = $validation->{data}; # warn Dumper $data; # ie $dfv->valid
        my $pds  = $validation->{pds_result}; # warn Dumper $pds;
        
        # generate_pdf param created in tt if PDS returns SMSP-0000 or _skip_pds
        # param submitted:
        unless ( $vars->{generate_pdf} ) {
            return template 'web_form', { pds => $pds }; # params in 'before_template' hook
        }
        { # generate unique ref for db:
            my $unique_id = _build_unique_id($data); # warn Dumper $unique_id;
            $data->{id} = $unique_id;
        }    
        { # save data to db:        
            my $db = RequestForm::DB->new();
            $db->save_params($data);
        }
        { # generate barcode for printed form:
            my @args = (reference => $data->{id}); # returns html table:
            my $o = RequestForm::BarCode->new(@args);
            $data->{barcode} = $o->create_2d_barcode;
            $data->{qrcode}  = $o->create_3d_barcode;
        }
        { # set headers & return PDF form for user to print & send:
            my $content = template 'pdf_form', { data => $data },
                { layout => 'pdf' }; # override default 'main' layout
            return $content if dancer_app->environment eq 'development';
            
            my $pdf = RequestForm::PDF->new(content => $content)->render;
            header 'Content-Type' => 'application/pdf';
            return $pdf;
        }
    }
    # validation failed:    
    elsif ( my $errs = $validation->{errs} ) { # return errs to input form: 
        template 'web_form', { errs => $errs }; # params in 'before_template' hook
    }
};

sub _validate {
    my $vars = shift;
    
    my $dfv = RequestForm::Validate->new(session => session, settings => config);
    # get $result - hashref of keys = errs (if failed) or data + pass (success):
    my $result = $dfv->validate($vars); # warn Dumper $validation;
    return $result;
}

sub _build_unique_id {
    my $vars = shift;
    my $now = DateTime->now->epoch;
    
    # id = datetime epoch + last_name + first initial:
    my $id = $now . uc( $vars->{last_name} . substr($vars->{first_name}, 0, 1) );
    return $id;    
}

true;
