package RequestForm::Validate::Ajax;

use Dancer2;
use LIMS::Local::Utils;
use RequestForm::Class; # provides Moo, Local::MooX::Types & LIMS::Local::Debug::p

prefix '/ajax';

# set serializer => 'JSON';

# nhs number ajax validation ('get' returns a string, 'post' returns json):
any [ qw(get post) ] => '/validate_nhs_number' => sub {
    my $var = params->{nhs_number}; # p $var;
    my $is_valid = LIMS::Local::Utils::check_nhsno($var) ? 'OK' : 'invalid';

    # web form jquery $.ajax function sends a 'post' request, alternative is $.get
    if (request->is_post) {
        my $json = to_json({ result => $is_valid });
        return $json;
    }
    else { return $is_valid }
};

get '/jquery_location' => sub {
    my $term = param 'term'; # warn $term;
    return unless $term && length $term >= 3; # using maxlength in js to ensure

    my $ctr = dancer_app->environment ne 'development'
        ? session->read('centre') : 'leeds'; # p $ctr;
    my $db  = RequestForm::DB->new(dbname => $ctr);

    my $locations = $db->get_referral_sources($term); # p $sources;
    my @results = map {
        {
            id    => $_->{id},
            label => $_->{display_name}, # jquery autocomplete changes label ->
            value => $_->{display_name}, # val when selected
        }
    } @$locations;

    my $json = to_json(\@results); # p $json;
    return $json;
};

get '/jquery_referrer' => sub {
    my $term = param 'term'; # warn $term;
    return unless $term && length $term >= 3; # using maxlength in js to ensure

    my $loc_id = param 'location_id'
    or return to_json(['please select location first']); # warn $loc_id;

    my $ctr = dancer_app->environment ne 'development'
        ? session->read('centre') : 'leeds'; # p $ctr;
    my $db  = RequestForm::DB->new(dbname => $ctr);

    my $refs = $db->get_referrers($term, $loc_id); # p $refs;
    my @results = map $_->{name} . ' [' . $_->{display_name} . ']', @$refs;

    my $json = to_json(\@results); # p $json;
    return $json;
};

# bsn.AutoSuggest.jQuery method, returns json:
get '/autosuggest_location' => sub {
    my $ref_src = param 'ref_src'; # warn $ref_src;
    return unless $ref_src && length $ref_src >= 3;

    my $ctr = session->read('centre'); # p $ctr;
    my $db  = RequestForm::DB->new(dbname => $ctr);

    my $locations = $db->get_referral_sources($ref_src); # p $sources;

    # manipulate $locations to provide keys for AJAX caller:
    my @results = map {
        {
            id    => $_->{id},
            value => $_->{display_name},
            info  => $_->{organisation_code},
        }
    } @$locations;

    my $json = to_json({ results => \@results }); # p $json;
    return $json;
};

# bsn.AutoSuggest.jQuery method, returns json:
get '/autosuggest_referrer' => sub {
    my $ref = param 'referrer'; # warn $ref;
    # my $id  = param 'location_id';

    return unless $ref && length $ref >= 3;

    my $ctr = session->read('centre'); # p $ctr;
    my $db  = RequestForm::DB->new(dbname => $ctr);

    my $referrers = $db->get_referrers($ref); # p $referrers;

    # manipulate $locations to provide keys for AJAX caller:
    my @results = map {
        {
            id    => $_->{id},
            value => $_->{name} . ' [' . $_->{display_name} . ']',
            info  => $_->{description},
        }
    } @$referrers;

    my $json = to_json({ results => \@results }); # p $json;
    return $json;
};

1;
