package RequestForm::Test;

# imports lib paths, Modern::Perl, etc into t/ scripts

use Modern::Perl;

use Import::Into;
use YAML::Tiny;
use Exporter ();
use FindBin; # warn $FindBin::Bin;

use lib (
    '/home/raj/perl-lib', # MooX::Types
    $FindBin::Bin . '/../../HILIS4/lib', # LLU
);
use LIMS::Local::Utils;
use Local::DB;

my $SCHEMA_SET = 0; # warn $SCHEMA_SET;
init_db() || die 'initialise db failed';

open my $fh, '>' . $FindBin::Bin . '/mech.htm' or die $!;

sub print_output {
    my $response = shift;
    print $fh $response->{content};
}

sub form_tokens {
    my $key = LIMS::Local::Utils::today->ymd;
    my $enc = sub { LIMS::Local::Utils::encrypt(shift, $key) };
    return sprintf 'c=%s;u=%s', &$enc('test'), &$enc('test'); # sqlite db
}

sub patient_data {
    my $patient = YAML::Tiny->read( 'src/patients.conf' ) or die $!; # ddp $patient;
    # don't call PDS, and attempt is fatal anyway somewhere in patient_demographic_service()
    $_->{_skip_pds} ||= 1 for @$patient; # dpp $patient;
    return $patient;
}

sub get_dbix { Local::DB->dbix({ dsn => 'dbi:SQLite:dbname=:memory:' }) }

sub init_db {
    return 1 if $SCHEMA_SET;

    my $dbix = get_dbix();
    my @schema = _schema();
    do { $dbix->dbh->do($_) || die $dbix->error } foreach @schema; # $dbix->error doesn't work here
    $SCHEMA_SET = 1;
}

# sub test_schema { _schema() } # probably don't need

our @EXPORT = qw(print_output form_tokens patient_data get_dbix);

sub import {
    LIMS::Local::Utils->import::into(1);
    RequestForm::DB->import::into(1);
    Modern::Perl->import::into(1);
    Local::DB->import::into(1);
    Data::Dumper->import::into(1);
    Data::Printer->import::into(1);
    DateTime->import::into(1);
    Clone->import::into(1, 'clone');

    goto &Exporter::import;
}

1;

sub _schema {
    return (
        q{
            CREATE TABLE users(
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                username TEXT,
                first_name TEXT,
                last_name TEXT
            )
        },
        q{
            INSERT INTO users(username, first_name, last_name)
                VALUES('test', 'fname','lname')
        },
        q{
            CREATE TABLE patients (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                last_name TEXT,
                first_name TEXT,
                dob TEXT,
                gender TEXT,
                nhs_number INT
            )
        },
        q{
            CREATE TABLE parent_organisations (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                parent_code TEXT,
                description TEXT
            )
        },
        q{
            INSERT INTO parent_organisations (parent_code, description)
                VALUES('ABC','NEWTOWN')
        },
        q{
            CREATE TABLE hospital_departments (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                display_name TEXT
            )
        },
        q{
            INSERT INTO hospital_departments(id, display_name)
                VALUES(823,'Haematology')
        },
        q{
            CREATE TABLE referrer_department (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                referrer_id INTEGER,
                parent_organisation_id  INTEGER,
                hospital_department_code TEXT,
                is_active TEXT
            )
        },
        q{
            INSERT INTO referrer_department
                (referrer_id, parent_organisation_id, hospital_department_code,
                    is_active) VALUES(1, 1, 823, 'yes')
        },
        q{
            CREATE TABLE referrers (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                name TEXT,
                national_code TEXT
            )
        },
        q{
            INSERT INTO referrers (name, national_code)
                VALUES('Brown AB', 'C123456')
        },
        q{
            CREATE TABLE referral_sources (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                display_name TEXT,
                parent_organisation_id INT,
                organisation_code TEXT,
                referral_type_id INT,
                is_active TEXT
            )
        },
        q{
            INSERT INTO referral_sources (display_name,parent_organisation_id,
                    organisation_code, referral_type_id, is_active)
                VALUES('Newtown General Infirmary', 1, 'ABC01', 1, 'yes')
        },
        q{
            CREATE TABLE referral_types (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                description TEXT
            )
        },
        q{
            INSERT INTO referral_types(description) VALUES('hospital')
        },
        q{
            CREATE TABLE request_form(
                id TEXT,
                last_name TEXT,
                first_name TEXT,
                dob TEXT,
                gender TEXT,
                nhs_number INTEGER,
                patient_number TEXT,
                location_name TEXT,
                location_id INTEGER,
                referrer TEXT,
                pds_code TEXT,
                user_id INTEGER,
                created TEXT,
                imported TEXT
            )
        },
    );
}
