package RequestForm::Role::PDS;

use Moo::Role;
with 'LIMS::Controller::Roles::PatientDemographics'; # some methods overriden above

use FindBin;
use Path::Tiny;
use Data::Dumper::Concise;
use LIMS::Local::Utils;

# supplies local versions of LIMS::Controller::Roles::PatientDemographics methods:
#-------------------------------------------------------------------------------
sub get_session_data { shift->session->read('_pds_data') } # original assumed CGI::Session
sub session_store_hashref {
    my ($self, $data, $key_name) = @_;
    $self->session->write($key_name => $data);
}
sub require_proxy {
    shift->settings->{patient_demographic_service}->{pds_proxy} ? 1 : 0;
}
sub get_username { 'RequestForm' } # maybe better to use remote IP address
sub user_profile { { id => 459 } } # hmds.lth - can't use HILIS user.id
sub get_logfile { path($FindBin::RealBin, '..', 'logs/sms.csv')->realpath }
sub messages { shift->settings->{patient_demographic_service}->{messages}  }
sub cfg      { shift->settings->{patient_demographic_service} }
#-------------------------------------------------------------------------------

sub patient_demographic_service {
    my ($self, $data) = @_;

    my $nhs_number = $data->{nhs_number};
    my $session = $self->session; # warn Dumper $session;

    # create hash of patient data used by PDS & store in session:
    my %patient = map +($_ => $data->{$_}),
        qw(last_name first_name gender nhs_number);
    $patient{dob} = $data->{dob}->dmy;

    # check that submitted vars haven't changed - compare to session stored:
    if ( my $stored = $session->read($nhs_number) ) { # warn 'have data';
        # no need to hit PDS again if patient details unchanged between submits:
        return 0 if LIMS::Local::Utils::compare_hash($stored, \%patient); # true if same
    }
    else { # warn 'no data - writing';
        $session->write($nhs_number => \%patient);
    }

    # get result of PDS lookup:
    my $pds_result = $self->get_pds_data($data); # warn Dumper $pds_result;
    return $pds_result;
}

1;