package RequestForm;

use Dancer2;
use Dancer2::Plugin::Ajax; # TODO: ajax prefix not recognised

use RequestForm::DB;
use RequestForm::PDF;
use RequestForm::BarCode;
use RequestForm::Validate;

use Data::Dumper::Concise;

our $VERSION = '0.1';

hook before => sub {
    my $vars = params;
    debug Dumper $vars if dancer_app->environment eq 'development';
};

hook before_template => sub {
    my $tokens = shift;
    $tokens->{uri_for_ajax_ref_src} = uri_for('autosuggest_referral_source');
    $tokens->{params} = params; # feed query params back
};

get '/index' => sub { template 'index', {}, { layout => 'index' } };

get '/' => sub { template 'web_form' };

post '/' => sub {
    my $vars = params; # warn Dumper $vars;
    
    my $validation = _validate($vars); # warn Dumper $validation; # href

    # if $validation has 'pass' key, save params to db & return PDF to print:  
    if ( $validation->{pass} ) { # no validation errors
        my $data = $validation->{data}; # warn Dumper $data; # ie $dfv->valid
        
        unless ( $vars->{is_validated} ) {
            $vars->{is_validated} = 1; # to allow form re-submission to pass
            return template 'web_form'; # params in 'before_template' hook
        }
        { # generate unique ref for db:
            my $unique_id = _build_unique_id($data); # warn Dumper $unique_id;
            $data->{id} = $unique_id;
        }    
        { # save data to db:        
            my $db = RequestForm::DB->new();
            $db->save_params($data);
        }
        { # generate barcode for printed form:
            my @args = (reference => $data->{id}); # returns html table:
            my $o = RequestForm::BarCode->new(@args);
            $data->{barcode} = $o->create_2d_barcode;
            $data->{qrcode}  = $o->create_3d_barcode;
        }
        { # set headers & return PDF form for user to print & send:
            my $content = template 'pdf_form', { data => $data },
                { layout => 'pdf' }; # override default 'main' layout
            my $pdf = RequestForm::PDF->new(content => $content)->render;
            header 'Content-Type' => 'application/pdf';
            return $pdf;
        }
    }
    # validation failed:    
    elsif ( my $errs = $validation->{errs} ) { # return errs to input form: 
        template 'web_form', { errs => $errs }; # params in 'before_template' hook
    }
};

ajax '/nhs_number/:var' => sub { # warn 'here'; warn Dumper params;
    warn params->{var};
    to_xml({}, RootName => undef);
};

# bsn.AutoSuggest.jQuery method, returns json (this should be 'ajax' prefix):
get '/autosuggest_referral_source' => sub {
    my $var = params->{ref_src}; # warn $var;
    return unless $var && length $var >= 3;

    my $results = _get_referral_sources($var); # warn Dumper $data; # AoH
    my $json = to_json({ results => $results }); # warn $json;
    return $json;
};

sub _get_referral_sources {
    my $str = shift;
    
    my $db = RequestForm::DB->new();
    my $results = $db->get_referral_sources($str); # warn Dumper $sources;
    
    # manipulate $results to provide keys for AJAX caller:
    my @data = map {
        {
            id    => $_->{id},
            value => $_->{display_name},
            info  => $_->{organisation_code},
        }
    } @$results;
    return \@data;
}

sub _validate {
    my $vars = shift;
    
    my $dfv = RequestForm::Validate->new(session => session, settings => config);
    # get $result - hashref of keys = errs (if failed) or data + pass (success):
    my $result = $dfv->validate($vars); # warn Dumper $validation;
    return $result;
}

sub _build_unique_id {
    my $vars = shift;
    my $now = DateTime->now->epoch;
    
    # id = datetime epoch + last_name + first initial:
    my $id = $now . uc( $vars->{last_name} . substr($vars->{first_name}, 0, 1) );
    return $id;    
}

true;
