use Test::WWW::Mechanize;
use LWP::Protocol::PSGI;

use Test::More import => ['!pass']; # tests => 3;

use RequestForm::Test;
use RequestForm;

my $psgi_app = RequestForm::runner()->psgi_app;
LWP::Protocol::PSGI->register($psgi_app);

my $mech = Test::WWW::Mechanize->new;

# submit invalid nhs_number:
$mech->get_ok('http://localhost/');                        # print_output($mech);
$mech->field(nhs_number => 1111111112);
$mech->submit_form();                                      # print_output($mech);
# p $mech->content( format => 'text' ); # span inside div:
$mech->text_contains('NHS number: invalid', 'OK: invalid nhs number detected');

# submit valid nhs_number:
$mech->get_ok('http://localhost/');                        # print_output($mech);
$mech->field(nhs_number => 1111111111);
$mech->submit_form();                                      # print_output($mech);
$mech->has_tag(
    p => 'No matching patient details found',
    'OK: nhs number submitted, no matching details found',
);

done_testing;