use Test::WWW::Mechanize;
use LWP::Protocol::PSGI;

use Test::More import => ['!pass']; # tests => 3;

use RequestForm::Test;
use RequestForm;

=begin # fires up a server just to trash it for every test
use Test::TCP;
Test::TCP::test_tcp( 
    client => sub {
        my $port = shift;

        my $mech = Test::WWW::Mechanize->new;
        $mech->get_ok( "http://localhost:$port/", 'a route handler is defined for /' );

        is $mech->status => 200, 'response status is 200 for /'; print_output($mech);
        $mech->title_is( 'HMDS RequestForm', 'title is okay' );

    },
    server => sub {
        use RequestForm;
        Dancer2->runner->{port} = shift;
        set log => 'error';
        dance;
    }
);
=cut

my $psgi_app = RequestForm::runner()->psgi_app;
LWP::Protocol::PSGI->register($psgi_app);

my $mech = Test::WWW::Mechanize->new;
$mech->get_ok(
    'http://localhost/',
    'OK: route handler is defined for /',
);                                                         # print_output($mech);

done_testing;