package RequestForm::Validate::Ajax;

use Dancer2;
use LIMS::Local::Utils;
use RequestForm::Class; # provides Moo, Local::MooX::Types & LIMS::Local::Debug::p

prefix '/ajax';

# nhs number ajax validation ('get' returns a string, 'post' returns json):
any [ qw(get post) ] => '/validate_nhs_number' => sub {
    my $var = params->{nhs_number}; # p $var;
    my $is_valid = LIMS::Local::Utils::check_nhsno($var) ? 'OK' : 'invalid';

    # web form jquery $.ajax function sends a 'post' request, alternative is $.get
    if (request->is_post) {
        my $json = to_json({ result => $is_valid });
        return $json;
    }
    else { return $is_valid }
};

# bsn.AutoSuggest.jQuery method, returns json:
get '/autosuggest_location' => sub {
    my $ref_src = param 'ref_src';
    return unless $ref_src && length $ref_src >= 3;

    # my $db = var 'db'; p $db; # no access to RequestForm vars ??
    my $ctr = session->read('centre');
    my $db  = RequestForm::DB->new(dbname => $ctr);
    
    my $locations = $db->get_referral_sources($ref_src); # p $sources;
    
    # manipulate $locations to provide keys for AJAX caller:
    my @results = map {
        {
            id    => $_->{id},
            value => $_->{display_name},
            info  => $_->{organisation_code},
        }
    } @$locations;
    
    my $json = to_json({ results => \@results }); # p $json;
    return $json;
};

1;
