package RequestForm::DB;

use lib '/home/raj/perl-lib';
use LIMS::Local::Utils;
use Local::DB;

use RequestForm::Class; # provides Moo, Local::MooX::Types & LIMS::Local::Debug::p
has dbname => ( is => 'ro', isa => String, required => 1 ); # uclh, hilis4, etc
has dbix   => ( is => 'lazy' ); # returns DBIx::Simple object

sub _build_dbix {
    my $db = shift->dbname; # dbname = uclh, leeds, etc
    $db =~ s/leeds/hilis4/; # leeds -> hilis4 symlink doesn't work on innodb tables
    Local::DB->dbix($db);
}

sub save_params {
    my $self = shift;
    my $vars = shift; # p $vars;
    
    # get field names from request_form table:
    my $cols = $self->get_cols('request_form'); # p $cols;    
    my %h = map +($_ => $vars->{$_}), @$cols; # p %h;

    my $db = $self->dbix();
    $db->insert('request_form', \%h);
}

sub search_patient {
    my ($self, $nhs_number) = @_; # p $nhs_number;
    
    my $db = $self->dbix();
    my $data = $db->select('patients', '*', { nhs_number => $nhs_number })->hash;
    return $data;
}

sub get_referral_sources {
    my $self = shift;
    my $str  = shift; # part of referral_location (string)
    
    my $db = $self->dbix();

    # get id of referral_types for hospital:
    $db->select('referral_types', 'id', { description => 'hospital' })
        ->into(my $ref_type_id);

    my @cols = qw(id display_name organisation_code);
    my %args = (
        referral_type_id => $ref_type_id,
        display_name => { rlike => $str },
        is_active    => 'yes',
    );

    my $vars = $db->select('referral_sources', \@cols, \%args )->hashes; # p $vars;
    return $vars;
}

sub get_userid {
    my ($self, $username) = @_;
    
    my $db = $self->dbix();
    $db->select('users', 'id', { username => $username })->into(my $user_id);
    return $user_id;
}

sub get_cols {
	my ($self, $table) = @_;
	
	my $meta = $self->get_meta($table); # p $meta;	
	return [ keys %$meta ];
}

sub get_meta {
	my ($self, $table) = @_;
	
	my $dbh = $self->dbix;
	
	my $t = $dbh->query("show columns from $table")->hashes; # p $t;
	
	my %meta = map { $_->{field} => $_ } @$t; # p %meta;	
	return \%meta;
}

1;