package RequestForm::PDF;

use IO::All;
use File::Temp qw(tempfile);

use RequestForm::Class; # provides Moo, Local::MooX::Types & LIMS::Local::Debug::p
has content => ( is => 'ro', isa => String, required => 1 );

sub render {
    my $content = shift->content; # p $content;

    # create temp file for input to wkhtmltopdf (default is to UNLINK):
    my $tmp_file = File::Temp->new(SUFFIX => '.html', UNLINK => 1); # p $tmp_file;	
	io($tmp_file->filename)->print($content); # save file to disk

    my @args = (
        '--margin-top 3',
    );

    my $pdf = `/usr/local/bin/wkhtmltopdf -q @args $tmp_file -`;
    return $pdf;

    # not required if using File::Temp OO interface (destroy is automatic):
    if ( -e $tmp_file ) {
        io($tmp_file)->unlink or warn "could not unlink $tmp_file: $!";
    }
}

1;