package RequestForm::PDF;

use Moo;
use IO::All;
use Data::Dumper;
use File::Temp qw(tempfile);
use Local::MooX::Types qw(String);

has content => ( is => 'ro', isa => String, required => 1 );

sub render {
    my $content = shift->content; # warn Dumper $content;

    my @args = (
        '--margin-top 7', # combined with header-spacing to provide optimum layout
        '--header-spacing 2', # provide gap between header & banner
#		qq!--header-left "$report_id"!, # double-quote to allow for eg o'connor
		qq!--header-right 'Printed on: [date]'!, # [date] replaced by system date (in local format)
#        qq!--footer-html $base_addr/$footer!,
        '--header-font-size 8',
        '--margin-bottom 26', # provide space for footer
        '--disable-javascript', # if any
        '--disable-external-links', # no urls
        # '--footer-line', # draw line above - doesn't print
        # '--footer-spacing x', # might need this if long content reaches footer
	);

    # create temp file for input to wkhtmltopdf:
    my ($fh , $tmp_file) = tempfile(SUFFIX => '.html'); # warn $tmp_file;
	# save file to disk:
	io($tmp_file)->print($content); # $html is str
    my $pdf = `wkhtmltopdf -q @args $tmp_file -`; # TODO: dev process hangs here

#    if ( -e $tmp_file ) { # occasionally doesn't exist - maybe simultaneous access ??
#        io($tmp_file)->unlink or warn "could not unlink $tmp_file: $!";
#    }
    return $pdf;
}

1;