package RequestForm::DB;

use Moo;
use FindBin qw($Bin);
use Data::Dumper::Concise;

use lib '/home/raj/perl-lib';
use Local::DB;

has dbix => ( is => 'lazy' ); # returns DBIx::Simple object
sub _build_dbix { Local::DB->dbix('hilis4') }

sub save_params {
    my $self = shift;
    my $vars = shift; # warn Dumper $vars;
    
    # get field names from request_form table:
    my $cols = $self->get_cols('request_form'); # warn Dumper $cols;    
    my %h = map +($_ => $vars->{$_}), @$cols; # warn Dumper \%h;

    my $db = $self->dbix();
    $db->insert('request_form', \%h);
}

sub get_cols {
	my ($self, $table) = @_;
	
	my $meta = $self->get_meta($table); # warn Dumper $meta;	
	return [ keys %$meta ];
}

sub get_meta {
	my ($self, $table) = @_;
	
	my $dbh = $self->dbix;
	
	my $t = $dbh->query("show columns from $table")->hashes; # warn Dumper $t;
	
	my %meta = map { $_->{field} => $_ } @$t; # warn Dumper \%meta;	
	return \%meta;
}

1;