package RequestForm::BarCode;

use Moo;
use DateTime;
use HTML::Barcode::Code93;
# use HTML::Barcode::QRCode; # need QR code reader
use Local::MooX::Types qw(String);

has reference => ( is => 'ro', isa => String, required => 1 );

sub create_2d_barcode {
    my $self = shift;
    
    my $ref = $self->reference;
    my $img = HTML::Barcode::Code93->new(bar_height => 20, text => $ref);
    return $img->render_barcode;
}

sub create_3d_barcode {
    my $self = shift;
   
    my $ref = $self->reference;
    my $img = HTML::Barcode::QRCode->new(text => $ref);
    return $img->render_barcode;
}

1;