package RequestForm;

use Dancer2;
use Dancer2::Plugin::Ajax;

use RequestForm::DB;
use RequestForm::PDF;
use RequestForm::BarCode;
use RequestForm::Validate;

use Data::Dumper::Concise;

our $VERSION = '0.1';

hook before => sub { };

get '/index' => sub { template 'index' }; # [% vars.time %]

get '/' => sub { template 'form' };

post '/' => sub {
    my $vars = params; # warn Dumper $vars;
    
    my $validation = _validate($vars); # warn Dumper $validation; # href

    # if $validation has 'pass' key, save params to db & return PDF to print:  
    if ( $validation->{pass} ) { # no validation errors
        my $data = $validation->{data}; # warn Dumper $data; # ie $dfv->valid
        
        { # generate unique ref for db:
            my $unique_id = _build_unique_id($data); # warn Dumper $unique_id;
            $data->{id} = $unique_id;
        }    
        { # save data to db:        
            my $db = RequestForm::DB->new();
            $db->save_params($data);
        }
        { # generate barcode for printed form:
            my @args = (reference => $data->{id}); # returns html table:
            my $barcode = RequestForm::BarCode->new(@args)->create_2d_barcode;
            $data->{barcode} = $barcode; # warn $barcode; 
        }
        { # set headers & return PDF form for user to print & send:
            my $content = template 'form_pdf', { data => $data }; # return $content;
            my $pdf = RequestForm::PDF->new(content => $content)->render;
            header 'Content-Type' => 'application/pdf';
            return $pdf;
        }
    }
    # validation failed:    
    else { # return errs to input form: 
        my $errors = $validation->{errs}; # warn Dumper $errors;
        template 'form', { errs => $errors, params => $vars };
    }
};

ajax '/nhs_number/:var' => sub { # warn 'here'; warn Dumper params;
    warn params->{var};
    to_xml({}, RootName => undef);
};

sub _validate {
    my $vars = shift;
    
    my $dfv = RequestForm::Validate->new();
    # get $result - hashref of key = errs (if failed) or data (if passed):
    my $result = $dfv->validate($vars); # warn Dumper $validation; # errs or data keys

    $result->{pass} = 1 if ( ! $result->{errs} ); # errs key if validation failed
    return $result;
}

sub _build_unique_id {
    my $vars = shift;
    my $now = DateTime->now->epoch;
    
    # id = datetime epoch + last_name + first initial:
    my $id = $now . uc( $vars->{last_name} . substr($vars->{first_name}, 0, 1) );
    return $id;    
}

true;
