package RequestForm::Validate::Ajax;

use Dancer2;
use LIMS::Local::Utils;

prefix '/ajax';

# nhs number ajax validation ('get' returns a string, 'post' returns json):
any [ qw(get post) ] => '/validate_nhs_number' => sub {
    my $var = params->{nhs_number}; # warn $var;
    my $is_valid = LIMS::Local::Utils::check_nhsno($var) ? 'OK' : 'invalid';

    # web form jquery $.ajax function sends a 'post' request, alternative is $.get
    if (request->is_post) {
        my $json = to_json({ result => $is_valid });
        return $json;
    }
    else { return $is_valid }
};

# bsn.AutoSuggest.jQuery method, returns json:
get '/autosuggest_location' => sub {
    my $var = params->{ref_src}; # warn $var;
    return unless $var && length $var >= 3;

    my $results = _get_referral_sources($var); # warn Dumper $data; # AoH
    my $json = to_json({ results => $results }); # warn $json;
    return $json;
};

sub _get_referral_sources {
    my $str = shift;
    
    my $db = RequestForm::DB->new();
    my $results = $db->get_referral_sources($str); # warn Dumper $sources;
    
    # manipulate $results to provide keys for AJAX caller:
    my @data = map {
        {
            id    => $_->{id},
            value => $_->{display_name},
            info  => $_->{organisation_code},
        }
    } @$results;
    return \@data;
}

1;
