use WWW::Mechanize::TreeBuilder;
use Test::WWW::Mechanize;
use LWP::Protocol::PSGI;
use Test::More;

use Data::Printer alias => 'ddp';
use Clone qw(clone);
use YAML::Tiny;
# use IO::All; # for debug use

use RequestForm::Test;
use RequestForm;

my $psgi_app = RequestForm::runner()->psgi_app;
LWP::Protocol::PSGI->register($psgi_app);

my $mech = Test::WWW::Mechanize->new;
WWW::Mechanize::TreeBuilder->meta->apply($mech);

my $args = form_tokens(); # warn $args;

my $config = YAML::Tiny->read( 'config.yml' ) or die $!; # ddp $config;
my $required_fields = $config->[0]->{validation}->{required};

my $patient = patient_data(); # ddp $patient;
my $data = $patient->[0]; # dpp $data;

# delete any row in lims_test.patients where nhs_number = $data->{nhs_number}:
my $dbix = Local::DB->dbix('lims_test');
$dbix->delete('patients', { nhs_number => $data->{nhs_number} });

# initialise session with form tokens:
$mech->get_ok("http://localhost/?$args");                 # print_output($mech);

# submit invalid nhs_number:
$mech->get('http://localhost/');                          # print_output($mech);
$mech->field(nhs_number => $data->{nhs_number} + 1);
$mech->submit_form();                                     # print_output($mech);
# p $mech->content( format => 'text' ); # span inside div:
$mech->text_contains('NHS number: invalid', 'OK: invalid nhs number detected');

# submit valid nhs_number:
$mech->get('http://localhost/');                          # print_output($mech);
$mech->field(nhs_number => $data->{nhs_number});
$mech->submit_form();                                     # print_output($mech);
$mech->has_tag(
    p => 'No matching patient details found',
    'OK: nhs number submitted, no matching details found',
);

{ # submit invalid data set:
    # for each required field, clone data, delete key & test for validation failure:
    for my $field (@$required_fields) { # warn $field; # next;
        next if $field eq 'location_name'; # tt uses location_id not name (ajax function)

        my $clone = clone($data); # dpp $clone;
        delete $clone->{$field};  # dpp $clone;

        $mech->post('http://localhost/', $clone);
            # io($FindBin::Bin . '/'.$field.'.htm')->print($mech->{content});
        $mech->has_tag(
            div => 'Missing',
            "OK: $field field missing",
        );
    }
}
{ # submit valid dataset:
    $mech->post('http://localhost/', $data);              # print_output($mech);
    $mech->has_tag_like(
        p => qr/Form passed validation/,
        'OK: validation passed',
    );

    # put _skip_pds back in (not retained in form):
    $mech->field( _skip_pds => 1 );
    # submit form to generate pdf (or HTML for non-deployment env):
    $mech->submit_form();                                 # print_output($mech);

    ok( # barcode class table:
       $mech->look_down(_tag => 'table', class => 'hbc'), # table class="hbc"
       'OK: has barcode table element',
    );

    { # look for unique ref (eg 1428054818SILVERO):
        my $ref = uc( $data->{last_name} . substr($data->{first_name}, 0, 1) ); # ddp $ref;
        $mech->has_tag_like(
            td => qr/\d+$ref/,
            'OK: unique ref id found',
        );
    }
    # look for each required field (except special format fields):
    for my $field (@$required_fields) { # warn Dumper [$field, $data->{$field}]; # next;
        # defer testing fields with special formatting (tested below):
        next if grep $field eq $_, # location_id not present at pdf generation stage:
            qw(last_name nhs_number day month year location_id);
        $mech->has_tag( span => $data->{$field}, "OK: $field field found" );
    }

    { # look for special format fields (dob, last_name, nhs_number):
        my $nhs_number = join ' ', # amazingly, this works:
            ( $data->{nhs_number} =~ /(\d{3})(\d{3})(\d{4})/ ); # ddp $nhs_number;
        my $last_name = uc $data->{last_name};
        my $dob = sprintf '%02d-%02d-%s', @{$data}{ qw(day month year) };

        my %formatted = (
            nhs_number => $nhs_number,
            last_name  => $last_name,
            dob        => $dob,
        );

        while ( my ($key, $val) = each %formatted ) {
            $mech->has_tag( span => $val, "OK: $key field found" );
        }
    }
}

done_testing(44);
