package Model;

use DBIx::Simple;
use Data::Printer;

use Moo;
has dbh  => ( is => 'ro', required => 1 );
has dbix => (
    is => 'lazy',
    builder => sub { DBIx::Simple->new(shift->dbh) },
);

sub authenticate_user { # basic auth for demo - just checks for username
    my ($self, $params) = @_; # p $params;
    return $params->{username} || 0;
}

sub get_data {
    my $self = shift;
    my ($sql, @bind) = @_;

    my $data = $self->dbix->query($sql, @bind)->hashes; # p $data;
    # return ref to array of hashrefs or single hashref:
    return @$data > 1
        ? $data # AoH
        : $data->[0]; # href
}

=begin
sub _build_dbix { # warn 'building dbix object';
    my $dsn = 'dbi:mysql:database=hilis4;mysql_read_default_file=~/.local/mysql.cnf';
    DBIx::Simple->connect($dsn);
}
=cut

1;