-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               5.5.43-0+deb7u1 - (Debian)
-- Server OS:                    debian-linux-gnu
-- HeidiSQL Version:             9.3.0.4989
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping database structure for outreach_patient_access
CREATE DATABASE IF NOT EXISTS `outreach_patient_access` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `outreach_patient_access`;

-- Dumping structure for table outreach_patient_access.followup_options
CREATE TABLE IF NOT EXISTS `followup_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `option` varchar(20) DEFAULT NULL,
  `label` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.lab_params
CREATE TABLE IF NOT EXISTS `lab_params` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `param_name` varchar(25) NOT NULL DEFAULT '',
  `field_label` varchar(255) NOT NULL DEFAULT '',
  `field_type` enum('menu','int','decimal') DEFAULT 'int',
  `department_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `param_name` (`param_name`),
  KEY `department_id` (`department_id`),
  CONSTRAINT `lab_params_ibfk_1` FOREIGN KEY (`department_id`) REFERENCES `result_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.patients
CREATE TABLE IF NOT EXISTS `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_name` varchar(50) DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `middle_name` varchar(50) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `gender` enum('M','F','U') DEFAULT 'U',
  `nhs_number` varchar(10) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nhs_number` (`nhs_number`),
  KEY `name` (`last_name`,`first_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.patient_access
CREATE TABLE IF NOT EXISTS `patient_access` (
  `patient_id` int(11) unsigned NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `last_login` datetime NOT NULL DEFAULT '1900-01-01 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.patient_case
CREATE TABLE IF NOT EXISTS `patient_case` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `referral_source_id` smallint(6) NOT NULL DEFAULT '0',
  `unit_number` varchar(255) NOT NULL DEFAULT 'UNKNOWN',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `case` (`patient_id`,`unit_number`,`referral_source_id`),
  KEY `patient_id` (`patient_id`),
  KEY `referral_source_id` (`referral_source_id`),
  CONSTRAINT `patient_case_ibfk_1` FOREIGN KEY (`referral_source_id`) REFERENCES `referral_sources` (`id`),
  CONSTRAINT `patient_case_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.patient_demographics
CREATE TABLE IF NOT EXISTS `patient_demographics` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `address` varchar(255) DEFAULT NULL,
  `post_code` varchar(8) DEFAULT NULL,
  `contact_number` varchar(15) DEFAULT NULL,
  `gp_id` int(11) NOT NULL DEFAULT '0',
  `practice_id` smallint(6) NOT NULL DEFAULT '0',
  `status` enum('alive','dead') NOT NULL DEFAULT 'alive',
  `dod` date DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patient_id`),
  KEY `practice_id` (`practice_id`),
  KEY `patient_demographics_ibfk_3` (`gp_id`),
  CONSTRAINT `patient_demographics_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`),
  CONSTRAINT `patient_demographics_ibfk_2` FOREIGN KEY (`practice_id`) REFERENCES `referral_sources` (`id`),
  CONSTRAINT `patient_demographics_ibfk_3` FOREIGN KEY (`gp_id`) REFERENCES `referrers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.patient_dispatch_detail
CREATE TABLE IF NOT EXISTS `patient_dispatch_detail` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `dispatch_to` enum('home','alternate','GP') NOT NULL DEFAULT 'home',
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.referral_sources
CREATE TABLE IF NOT EXISTS `referral_sources` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `display_name` varchar(255) NOT NULL DEFAULT '',
  `organisation_code` varchar(6) NOT NULL DEFAULT '',
  `parent_organisation_id` smallint(6) NOT NULL DEFAULT '0',
  `referral_type_id` smallint(6) NOT NULL DEFAULT '0',
  `is_active` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `organisation_code` (`organisation_code`),
  UNIQUE KEY `display_name` (`display_name`),
  KEY `referral_type_id` (`referral_type_id`),
  KEY `parent_organisation_id` (`parent_organisation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.referrers
CREATE TABLE IF NOT EXISTS `referrers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `national_code` varchar(8) NOT NULL DEFAULT '',
  `referral_type_id` smallint(6) NOT NULL DEFAULT '0',
  `active` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `national_code` (`national_code`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.requests
CREATE TABLE IF NOT EXISTS `requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `request_number` smallint(6) NOT NULL DEFAULT '0',
  `year` year(4) NOT NULL DEFAULT '0000',
  `patient_case_id` int(11) NOT NULL DEFAULT '0',
  `referrer_department_id` int(11) NOT NULL DEFAULT '0',
  `status_option_id` smallint(6) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lab_no` (`request_number`,`year`),
  KEY `patient_case_id` (`patient_case_id`),
  KEY `referrer_department_id` (`referrer_department_id`),
  KEY `status_option_id` (`status_option_id`),
  CONSTRAINT `requests_ibfk_1` FOREIGN KEY (`status_option_id`) REFERENCES `status_options` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.request_followup
CREATE TABLE IF NOT EXISTS `request_followup` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `followup_option_id` smallint(6) NOT NULL DEFAULT '0',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`),
  KEY `followup_option_id` (`followup_option_id`),
  CONSTRAINT `request_followup_ibfk_1` FOREIGN KEY (`followup_option_id`) REFERENCES `followup_options` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.request_pack_dispatch
CREATE TABLE IF NOT EXISTS `request_pack_dispatch` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `pack_due` date DEFAULT NULL,
  `pack_sent` date DEFAULT NULL,
  `return_due` date DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.request_results
CREATE TABLE IF NOT EXISTS `request_results` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `param_id` smallint(6) NOT NULL DEFAULT '0',
  `result` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`request_id`,`param_id`),
  KEY `request_results_ibfk_1` (`param_id`),
  CONSTRAINT `request_results_ibfk_1` FOREIGN KEY (`param_id`) REFERENCES `lab_params` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.result_types
CREATE TABLE IF NOT EXISTS `result_types` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.


-- Dumping structure for table outreach_patient_access.status_options
CREATE TABLE IF NOT EXISTS `status_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;


/* to populate from HILIS4: */
INSERT INTO `outreach_patient_access`.`requests` (`id`, `request_number`, `year`,
    `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`)
    SELECT r.id, r.request_number, r.year, 1, 1, r.status_option_id, r.created_at
	FROM hilis4.requests r
	JOIN hilis4.patient_case pc on r.patient_case_id = pc.id
	JOIN ( hilis4.request_specimen rs JOIN hilis4.specimens s on rs.specimen_id = s.id )
		on rs.request_id = r.id
	WHERE pc.patient_id = 16600 AND s.sample_code = 'CMP';
    
INSERT INTO `outreach_patient_access`.`requests` (`id`, `request_number`, `year`,
    `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`)
    SELECT r.id, r.request_number, r.year, 2, 1, r.status_option_id, r.created_at
	FROM hilis4.requests r
	JOIN hilis4.patient_case pc on r.patient_case_id = pc.id
	JOIN ( hilis4.request_specimen rs JOIN hilis4.specimens s on rs.specimen_id = s.id )
		on rs.request_id = r.id
	WHERE pc.patient_id = 49144 AND s.sample_code = 'CMP';
/* screened */
INSERT INTO `outreach_patient_access`.`requests` (`id`, `request_number`, `year`,
    `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`)
    SELECT r.id, r.request_number, r.year, 3, 1, r.status_option_id, r.created_at
	FROM hilis4.requests r
	JOIN hilis4.patient_case pc on r.patient_case_id = pc.id
	JOIN ( hilis4.request_specimen rs JOIN hilis4.specimens s on rs.specimen_id = s.id )
		on rs.request_id = r.id
	WHERE pc.patient_id = 45916 AND s.sample_code = 'CMP';
/* new */
INSERT INTO `outreach_patient_access`.`requests` (`id`, `request_number`, `year`,
    `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`)
    VALUES(255352, 10937, 2015, 4, 1, 1, '2015-05-13 08:00:21');

INSERT INTO `outreach_patient_access`.`request_followup` (`request_id`, `followup_option_id`,`time`)
    SELECT r.id, rfu.followup_option_id, rfu.time
	FROM outreach_patient_access.requests r
	JOIN outreach_patient_access.patient_case pc on r.patient_case_id = pc.id
	JOIN outreach.request_followup rfu on rfu.request_id = r.id;

INSERT INTO outreach_patient_access.request_pack_dispatch(request_id,pack_due,pack_sent,return_due,time)
   SELECT r.id, rpd.pack_due, rpd.pack_sent, rpd.return_due, rpd.time
	FROM outreach_patient_access.requests r
	JOIN outreach.request_pack_dispatch rpd on rpd.request_id = r.id
	JOIN outreach_patient_access.patient_case pc on r.patient_case_id = pc.id;