-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               5.5.43-0+deb7u1 - (Debian)
-- Server OS:                    debian-linux-gnu
-- HeidiSQL Version:             9.3.0.4989
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping database structure for outreach_patient_access
USE `outreach_patient_access`;

-- Dumping data for table outreach_patient_access.followup_options: ~10 rows (approximately)
/*!40000 ALTER TABLE `followup_options` DISABLE KEYS */;
INSERT INTO `followup_options` (`id`, `option`, `label`) VALUES
	(1, 'zero_month', 'immediately'),
	(2, 'one_month', 'one month'),
	(3, 'three_month', 'three months'),
	(4, 'six_month', 'six months'),
	(5, 'twelve_month', 'twelve months'),
	(6, 'clinic_return', 'return to clinic'),
	(7, 'dead', 'dead'),
	(8, 'other', 'other'),
	(9, 'twenty_four_month', 'two years'),
	(10, 'sixty_month', 'five years');
/*!40000 ALTER TABLE `followup_options` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.lab_params: ~30 rows (approximately)
/*!40000 ALTER TABLE `lab_params` DISABLE KEYS */;
INSERT INTO `lab_params` (`id`, `param_name`, `field_label`, `field_type`, `department_id`) VALUES
	(1, 'sodium', 'Sodium', 'int', 3),
	(2, 'potassium', 'Potassium', 'decimal', 3),
	(3, 'creatinine', 'Creatinine', 'int', 3),
	(4, 'urea', 'Urea', 'decimal', 3),
	(5, 'alk_phos', 'AlkPhos', 'int', 3),
	(6, 'albumin', 'Albumin', 'int', 3),
	(7, 'calcium', 'Calcium', 'decimal', 3),
	(8, 'phosphate', 'Phosphate', 'decimal', 3),
	(9, 'total_protein', 'Protein', 'int', 3),
	(10, 'wbc', 'WBC', 'decimal', 2),
	(11, 'hb', 'Hb', 'int', 2),
	(12, 'plts', 'Plts', 'int', 2),
	(13, 'lymphs', 'Lymphs', 'decimal', 2),
	(14, 'IgG', 'IgG', 'decimal', 1),
	(15, 'IgA', 'IgA', 'decimal', 1),
	(16, 'IgM', 'IgM', 'decimal', 1),
	(17, 'paraprotein', 'Paraprotein', 'int', 1),
	(18, 'electrophoresis', 'Electrophoresis', 'menu', 1),
	(19, 'total_b_cells', 'B-cells', 'int', 4),
	(20, 'kappa', 'B &kappa,+', 'int', 4),
	(21, 'lambda', 'B &lambda,+', 'int', 4),
	(22, 'sIg_neg', 'B sIg-', 'int', 4),
	(23, 'cd5_pos', 'B CD5+', 'int', 4),
	(24, 'neoplastic_b_cells', 'Neo B', 'int', 4),
	(25, 'total_plasma_cells', "PC\'s", 'decimal', 4),
	(26, 'cd19_neg_pc', 'CD19- PC', 'decimal', 4),
	(27, 'globulin', 'Globulin', 'int', 1),
	(28, 'bilirubin', 'Bilirubin', 'decimal', 3),
	(29, 'alt', 'ALT', 'decimal', 3),
	(30, 'magnesium', 'Magnesium', 'decimal', 3);
/*!40000 ALTER TABLE `lab_params` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.patients: ~6 rows (approximately)
/*!40000 ALTER TABLE `patients` DISABLE KEYS */;
INSERT INTO `patients` (`id`, `last_name`, `first_name`, `middle_name`, `dob`, `gender`, `nhs_number`, `created_at`, `updated_at`) VALUES
	(1, 'melon', 'walter', NULL, '1940-01-01', 'M', '1111111111', '2015-09-01 13:43:45', '2015-09-01 13:43:45'),
	(2, 'case', 'justin', NULL, '1930-01-01', 'M', '2222222222', '2015-09-01 13:43:45', '2015-09-01 13:43:45'),
	(3, 'cart', 'orsen', NULL, '1950-01-01', 'M', '3333333333', '2015-09-01 13:43:45', '2015-09-01 13:43:45'),
	(4, 'nutt', 'hazel', NULL, '1960-01-01', 'F', '4444444444', '2015-09-01 13:43:45', '2015-09-01 13:43:45'),
	(5, 'shore', 'sandy', NULL, '1920-01-01', 'F', '5555555555', '2015-09-01 13:43:45', '2015-09-01 13:43:45'),
	(6, 'petal', 'rose', NULL, '1930-01-01', 'F', '6666666666', '2015-09-01 13:43:45', '2015-09-01 13:43:45');
/*!40000 ALTER TABLE `patients` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.patient_access: ~6 rows (approximately)
/*!40000 ALTER TABLE `patient_access` DISABLE KEYS */;
INSERT INTO `patient_access` (`patient_id`, `email`, `password`, `last_login`) VALUES
	(1, 'user1@email.net', 's9qne0wEqVUbh4HQMZH+CY8yXmc', '2015-09-02 00:28:50'),
	(2, 'user2@email.net', 'oYgcBu7JbbmQHHu/5BxCo/COnLQ', '2015-09-02 10:23:26'),
	(3, 'user3@email.net', 'C3+ElEbTODVG0VpICWYIRELNIZM', '2015-09-02 00:29:19'),
	(4, 'user4@email.net', 'Bubu9q3y5fVOpsQ8N21tNmBfgQ4', '2015-09-02 00:29:47'),
	(5, 'user5@email.net', 'fREmgbjdgHI4cah/9QYoZhP6nPY', '2015-09-02 00:29:58'),
	(6, 'user6@email.net', 'MSpG3FIRfvpOMJbtpRA3DwHIOyc', '2015-09-02 00:30:19');
/*!40000 ALTER TABLE `patient_access` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.patient_case: ~6 rows (approximately)
/*!40000 ALTER TABLE `patient_case` DISABLE KEYS */;
INSERT INTO `patient_case` (`id`, `patient_id`, `referral_source_id`, `unit_number`, `time`) VALUES
	(1, 1, 1, '112233', '2015-09-01 13:40:32'),
	(2, 2, 2, '223344', '2015-09-01 13:40:32'),
	(3, 3, 3, '334455', '2015-09-01 13:40:32'),
	(4, 4, 1, '445566', '2015-09-01 13:40:32'),
	(5, 5, 2, '556677', '2015-09-01 13:40:32'),
	(6, 6, 3, '667788', '2015-09-01 13:40:32');
/*!40000 ALTER TABLE `patient_case` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.patient_demographics: ~6 rows (approximately)
/*!40000 ALTER TABLE `patient_demographics` DISABLE KEYS */;
INSERT INTO `patient_demographics` (`patient_id`, `address`, `post_code`, `contact_number`, `gp_id`, `practice_id`, `status`, `dod`, `time`) VALUES
	(1, '1 The Green, Leeds', 'LS16 2AA', '0777 111 2222', 1, 1, 'alive', NULL, '2015-09-01 13:40:33'),
	(2, '2 The Green, Leeds', 'LS16 2AA', '0777 111 3333', 2, 2, 'alive', NULL, '2015-09-01 13:40:33'),
	(3, '3 The Green, Leeds', 'LS16 2AA', '0777 111 4444', 3, 3, 'alive', NULL, '2015-09-01 13:40:33'),
	(4, '4 The Green, Leeds', 'LS16 2AA', '0777 111 5555', 1, 1, 'alive', NULL, '2015-09-01 13:40:33'),
	(5, '5 The Green, Leeds', 'LS16 2AA', '0777 111 6666', 2, 2, 'alive', NULL, '2015-09-01 13:40:33'),
	(6, '6 The Green, Leeds', 'LS16 2AA', '0777 111 7777', 3, 3, 'alive', NULL, '2015-09-01 13:40:33');
/*!40000 ALTER TABLE `patient_demographics` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.patient_dispatch_detail: ~6 rows (approximately)
/*!40000 ALTER TABLE `patient_dispatch_detail` DISABLE KEYS */;
INSERT INTO `patient_dispatch_detail` (`patient_id`, `dispatch_to`) VALUES
	(1, 'home'),
	(2, 'home'),
	(3, 'home'),
	(4, 'home'),
	(5, 'home'),
	(6, 'home');
/*!40000 ALTER TABLE `patient_dispatch_detail` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.referral_sources: ~3 rows (approximately)
/*!40000 ALTER TABLE `referral_sources` DISABLE KEYS */;
INSERT INTO `referral_sources` (`id`, `display_name`, `organisation_code`, `parent_organisation_id`, `referral_type_id`, `is_active`) VALUES
	(1, 'Highfield Surgery, Holtdale Approach, Leeds, LS16 7RX', 'B86004', 1, 5, 'yes'),
	(2, 'Moor Grange, 60 Moor Grange View, Leeds, LS16 5BJ', 'B86065', 2, 5, 'yes'),
	(3, 'New Road Side Surgery, 127 New Road Side, Leeds, LS18 4QD', 'B86628', 3, 5, 'yes');
/*!40000 ALTER TABLE `referral_sources` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.referrers: ~3 rows (approximately)
/*!40000 ALTER TABLE `referrers` DISABLE KEYS */;
INSERT INTO `referrers` (`id`, `name`, `national_code`, `referral_type_id`, `active`) VALUES
	(1, 'KITCHEN CA', 'G8514138', 3, 'yes'),
	(2, 'MANCHESTER K', 'G3200140', 3, 'yes'),
	(3, 'CHANDAR NV', 'G8543918', 3, 'yes');
/*!40000 ALTER TABLE `referrers` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.requests: ~32 rows (approximately)
/*!40000 ALTER TABLE `requests` DISABLE KEYS */;
INSERT INTO `requests` (`id`, `request_number`, `year`, `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`, `updated_at`) VALUES
	(49112, 5894, '2006', 1, 1, 5, '2006-05-15 12:41:31', '2015-09-01 21:45:07'),
	(58157, 15075, '2006', 1, 1, 5, '2006-12-01 11:01:30', '2015-09-01 21:45:07'),
	(66149, 7027, '2007', 1, 1, 5, '2007-05-25 11:44:52', '2015-09-01 21:45:07'),
	(82974, 6959, '2008', 1, 1, 5, '2008-05-15 11:24:05', '2015-09-01 21:45:07'),
	(88681, 12634, '2008', 1, 1, 5, '2008-09-03 11:59:37', '2015-09-01 21:45:07'),
	(102696, 7803, '2009', 1, 1, 5, '2009-05-20 14:12:26', '2015-09-01 21:45:07'),
	(106066, 11170, '2009', 1, 1, 5, '2009-07-21 12:52:37', '2015-09-01 21:45:07'),
	(108296, 13406, '2009', 3, 1, 5, '2009-08-31 19:39:05', '2015-09-01 21:45:08'),
	(119041, 3779, '2010', 1, 1, 5, '2010-03-05 11:32:56', '2015-09-01 21:45:07'),
	(130850, 15583, '2010', 1, 1, 5, '2010-09-23 11:52:58', '2015-09-01 21:45:07'),
	(142966, 6295, '2011', 1, 1, 5, '2011-04-06 10:06:51', '2015-09-01 21:45:07'),
	(155606, 18940, '2011', 1, 1, 5, '2011-10-13 13:03:46', '2015-09-01 21:45:07'),
	(169141, 8193, '2012', 1, 1, 5, '2012-04-25 11:28:22', '2015-09-01 21:45:07'),
	(171158, 10187, '2012', 3, 1, 5, '2012-05-22 08:45:22', '2015-09-01 21:45:08'),
	(173829, 12852, '2012', 2, 1, 5, '2012-06-28 08:07:55', '2015-09-01 21:45:08'),
	(184049, 23060, '2012', 1, 1, 5, '2012-11-13 11:57:00', '2015-09-01 21:45:07'),
	(184950, 23983, '2012', 3, 1, 5, '2012-11-23 11:39:41', '2015-09-01 21:45:08'),
	(186097, 25082, '2012', 2, 1, 5, '2012-12-07 12:24:53', '2015-09-01 21:45:08'),
	(193767, 6180, '2013', 1, 1, 5, '2013-03-20 12:52:10', '2015-09-01 21:45:07'),
	(200138, 12506, '2013', 2, 1, 5, '2013-06-12 15:49:40', '2015-09-01 21:45:08'),
	(201110, 13490, '2013', 1, 1, 5, '2013-06-26 11:23:07', '2015-09-01 21:45:07'),
	(212203, 24542, '2013', 3, 1, 5, '2013-11-21 13:46:23', '2015-09-01 21:45:08'),
	(213721, 26076, '2013', 2, 1, 5, '2013-12-11 11:58:25', '2015-09-01 21:45:08'),
	(215181, 221, '2014', 1, 1, 5, '2014-01-07 10:16:52', '2015-09-01 21:45:07'),
	(225316, 10335, '2014', 3, 1, 5, '2014-05-13 12:40:04', '2015-09-01 21:45:08'),
	(227160, 12182, '2014', 2, 1, 5, '2014-06-04 15:15:55', '2015-09-01 21:45:08'),
	(229497, 14513, '2014', 1, 1, 5, '2014-07-02 11:59:59', '2015-09-01 21:45:07'),
	(235537, 20562, '2014', 1, 1, 5, '2014-09-16 09:04:17', '2015-09-01 21:45:07'),
	(242439, 27423, '2014', 2, 1, 5, '2014-12-04 12:24:56', '2015-09-01 21:45:08'),
	(251634, 7242, '2015', 1, 1, 5, '2015-03-26 12:34:58', '2015-09-01 21:45:07'),
	(255237, 10822, '2015', 3, 1, 2, '2015-05-12 08:19:14', '2015-09-01 21:45:08'),
	(255352, 10937, '2015', 4, 1, 1, '2015-05-13 08:00:21', '2015-09-01 21:45:08');
/*!40000 ALTER TABLE `requests` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.request_followup: ~30 rows (approximately)
/*!40000 ALTER TABLE `request_followup` DISABLE KEYS */;
INSERT INTO `request_followup` (`request_id`, `followup_option_id`, `time`) VALUES
	(49112, 2, '2006-11-24 17:02:34'),
	(58157, 4, '2006-12-19 22:24:46'),
	(66149, 4, '2007-06-05 14:44:15'),
	(82974, 3, '2008-06-02 16:19:52'),
	(88681, 4, '2008-09-21 02:12:10'),
	(102696, 1, '2009-06-18 16:32:37'),
	(106066, 4, '2009-08-11 11:07:41'),
	(108296, 6, '2009-09-03 12:27:55'),
	(119041, 4, '2010-03-15 20:43:50'),
	(130850, 4, '2010-10-04 21:19:41'),
	(142966, 4, '2011-04-12 15:22:01'),
	(155606, 4, '2011-10-23 23:43:10'),
	(169141, 4, '2012-05-08 21:55:07'),
	(171158, 4, '2012-06-07 18:55:19'),
	(173829, 4, '2012-06-29 11:27:00'),
	(184049, 6, '2012-11-22 12:24:33'),
	(184950, 5, '2012-12-04 23:43:39'),
	(186097, 4, '2012-12-17 15:26:06'),
	(193767, 3, '2013-03-29 01:25:51'),
	(200138, 4, '2013-06-25 14:05:28'),
	(201110, 4, '2013-07-04 13:39:19'),
	(212203, 4, '2013-12-02 23:02:00'),
	(213721, 4, '2013-12-17 13:45:43'),
	(215181, 4, '2014-01-16 13:03:48'),
	(225316, 5, '2014-05-20 15:18:29'),
	(227160, 4, '2014-06-10 14:47:52'),
	(229497, 6, '2014-07-24 15:04:23'),
	(235537, 4, '2014-09-16 10:35:27'),
	(242439, 4, '2014-12-18 12:25:02'),
	(251634, 4, '2015-04-04 10:32:08');
/*!40000 ALTER TABLE `request_followup` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.request_pack_dispatch: ~29 rows (approximately)
/*!40000 ALTER TABLE `request_pack_dispatch` DISABLE KEYS */;
INSERT INTO `request_pack_dispatch` (`request_id`, `pack_due`, `pack_sent`, `return_due`, `time`) VALUES
	(49112, '2006-06-11', '2006-08-23', '2006-09-23', '2006-11-27 10:40:14'),
	(58157, '2007-06-01', '2007-05-24', '2007-06-24', '2007-06-08 13:49:42'),
	(66149, '2007-11-25', '2007-11-28', '2007-12-28', '2007-11-28 11:04:11'),
	(82974, '2008-08-15', '2008-08-19', '2008-09-19', '2008-08-19 11:20:45'),
	(88681, '2009-03-03', '2009-03-03', '2009-04-03', '2009-03-03 10:02:27'),
	(102696, '2009-05-20', '2009-06-29', '2009-07-29', '2009-06-29 12:48:33'),
	(106066, '2010-01-21', '2010-01-21', '2010-02-21', '2010-01-21 12:18:28'),
	(119041, '2010-09-05', '2010-09-06', '2010-10-06', '2010-09-06 11:43:46'),
	(130850, '2011-03-09', '2011-03-10', '2011-04-10', '2011-03-10 12:30:26'),
	(142966, '2011-09-20', '2011-09-23', '2011-10-23', '2011-09-23 11:27:06'),
	(155606, '2012-03-30', '2012-04-04', '2012-05-04', '2012-04-04 12:33:26'),
	(169141, '2012-10-11', '2012-10-11', '2012-11-11', '2012-10-11 08:09:18'),
	(171158, '2012-11-08', '2012-11-19', '2012-12-19', '2012-11-19 13:23:30'),
	(173829, '2012-11-25', '2012-11-29', '2012-12-29', '2012-11-29 12:56:11'),
	(184049, '1999-01-01', NULL, NULL, '2012-11-22 12:24:33'),
	(184950, '2013-11-09', '2013-11-11', '2013-12-21', '2013-11-11 12:48:48'),
	(186097, '2013-05-24', '2013-06-05', '2013-07-15', '2013-06-05 08:07:18'),
	(193767, '2013-06-06', '2013-06-06', '2013-07-16', '2013-06-06 09:28:45'),
	(200138, '2013-11-28', '2013-11-28', '2014-01-07', '2013-11-28 11:58:52'),
	(201110, '2013-11-27', '2013-11-28', '2014-01-07', '2013-11-28 09:04:31'),
	(212203, '2014-05-07', '2014-05-08', '2014-06-17', '2014-05-08 08:33:03'),
	(213721, '2014-05-28', '2014-05-29', '2014-07-08', '2014-05-29 09:39:26'),
	(215181, '2014-06-23', '2014-06-23', '2014-08-02', '2014-06-23 09:18:29'),
	(225316, '2015-04-29', '2015-05-07', '2015-06-16', '2015-05-07 12:26:43'),
	(227160, '2014-11-20', '2014-11-20', '2014-12-30', '2014-11-20 09:51:46'),
	(229497, '1999-01-01', NULL, NULL, '2014-07-24 15:04:23'),
	(235537, '2015-03-02', '2015-03-03', '2015-04-12', '2015-03-03 07:59:00'),
	(242439, '2015-05-21', '2015-05-21', '2015-06-30', '2015-05-21 13:01:33'),
	(251634, '2015-09-12', NULL, NULL, '2015-04-04 10:32:08');
/*!40000 ALTER TABLE `request_pack_dispatch` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.request_results: ~0 rows (approximately)
/*!40000 ALTER TABLE `request_results` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_results` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.result_types: ~4 rows (approximately)
/*!40000 ALTER TABLE `result_types` DISABLE KEYS */;
INSERT INTO `result_types` (`id`, `description`) VALUES
	(1, 'immunology'),
	(2, 'haematology'),
	(3, 'biochemistry'),
	(4, 'flow_cytometry');
/*!40000 ALTER TABLE `result_types` ENABLE KEYS */;

-- Dumping data for table outreach_patient_access.status_options: ~5 rows (approximately)
/*!40000 ALTER TABLE `status_options` DISABLE KEYS */;
INSERT INTO `status_options` (`id`, `description`) VALUES
	(4, 'authorised'),
	(5, 'complete'),
	(1, 'new'),
	(3, 'reported'),
	(2, 'screened');
/*!40000 ALTER TABLE `status_options` ENABLE KEYS */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
