
/* dumper.tt function */
function toggleview_dumper (id1,id2) {
	var obj1 = document.getElementById(id1);
	var obj2 = document.getElementById(id2);
	(obj1.className=="itemshown") ? obj1.className="itemhidden" : obj1.className="itemshown";
	(obj1.className=="itemshown") ? obj2.innerHTML="[...]" : obj2.innerHTML="[...]";
}

/* for bootsnipp login */
function showPassword() {
    var key_attr = $('#key').attr('type');

    if(key_attr != 'text') {
        $('.checkbox').addClass('show');
        $('#key').attr('type', 'text');

    } else {
        $('.checkbox').removeClass('show');
        $('#key').attr('type', 'password');
    }
}

// magic.js
$(document).ready(function() {
	// process the form
	$('#patient-details').submit(function(event) {
		$('.form-group').removeClass('has-error'); // remove the error class
		$('.help-block').remove(); // remove the error text

		// get the form data
		// there are many ways to get this data using jQuery (you can use the class or id also)
		var formData = {
			'contact_number'	: $('input[name=contact_number]').val(),
			'password' 			: $('input[name=password]').val(),
			'first_name'		: $('input[name=first_name]').val(),
			'last_name'			: $('input[name=last_name]').val(),
			'address'			: $('input[name=address]').val(),
			'practice'			: $('input[name=practice]').val(),
			'email' 			: $('input[name=email]').val(),
			'dob'				: $('input[name=dob]').val()
		};

		// process the form
		$.ajax({
			type 		: 'POST', // define the type of HTTP verb we want to use (POST for our form)
			url 		: '/ajax_amend_details', // the url where we want to POST
			data 		: formData, // our data object
			dataType 	: 'json', // what type of data do we expect back from the server
			encode 		: true
		})
			// using the done promise callback
			.done(function(data) {
				// log data to the console so we can see
				console.log(data);

				// here we will handle errors and validation messages
				if ( ! data.success) {
					// handle errors for email field ---------------
					if (data.errors.email) {
						 // add the error class to show red input:
						$('#email-group').addClass('has-error');
						 // add the actual error message under our input:
						$('#email-group').append('<div class="help-block">'
							+ data.errors.email + '</div>');
					}
					// handle errors for password ---------------
					if (data.errors.password) {
						// add the error class to show red input:
						$('#password-group').addClass('has-error');
						// add the actual error message under our input:
						$('#password-group').append('<div class="help-block">'
							+ data.errors.password + '</div>');
					}
					// handle errors for email failure ---------------
					if (data.errors.sendmail) {
						$('#result').html('<div class="alert alert-danger">'
							+ data.errors.sendmail + '</div>');
					}
				}
				else {
					// ALL GOOD! just show the success message!
					$('#result').html('<div class="alert alert-success">'
							+ data.message + '</div>');

					// usually after form submission, you'll want to redirect
					// window.location = '/thank-you'; // redirect a user to another page
				}
			})

			// using the fail promise callback
			.fail(function(data) {
				// show any errors
				// best to remove for production
				console.log(data);
			});

		// stop the form from submitting the normal way and refreshing the page
		event.preventDefault();
	});
});
