use Test::More;

use AppTest;
use Template;
use Modern::Perl;
use Data::Printer alias => 'p';
use HTML::TreeBuilder::XPath;

use constant TMPL => 'packs.tt';

require_ok( 'AppTest' ); # Data::Printer, Moo, etc

my $app = AppTest->new;
my $tt  = Template->new( { INCLUDE_PATH => $app->config->{appdir} . '/views' } );

my $resultset = $app->model->dbix->select('patients', 'id');

my $i = 0;
while ( my $id = $resultset->value ) { # last if $id > 10000;
    my $data = $app->model->get_outreach_data($id); # p $data;
    my $content; $i++;

    # process input template, substituting variables
    $tt->process(TMPL, { data => $data }, \$content) || die $tt->error(); # p $content;

    my $tree = HTML::TreeBuilder->new_from_content($content); # p $tree; exit;
    # content of 'Your current pack status' div:
    my $status = $tree->findvalue( '//div[@class="panel-body"]/span');

    # next unless $status =~ /\*/;
    say $id, ': ', $status;
}
say "$i patients processed";

done_testing(1);
