INSERT INTO `outreach_patient_access`.`followup_options` (`option`, `label`) VALUES
    ('zero_month', 'immediately'),
    ('one_month', 'one month'),
    ('three_month', 'three months'),
    ('six_month', 'six months'),
    ('twelve_month', 'twelve months'),
    ('clinic_return', 'return to clinic'),
    ('dead', 'dead'),
    ('other', 'other'),
    ('twenty_four_month', 'two years'),
    ('sixty_month', 'five years');

INSERT INTO `outreach_patient_access`.`result_types` (`description`) VALUES
    ('immunology'),
    ('haematology'),
    ('biochemistry'),
    ('flow_cytometry');

INSERT INTO `outreach_patient_access`.`referral_sources` (`display_name`, `organisation_code`,
    `parent_organisation_id`, `referral_type_id`) VALUES
    ('Highfield Surgery, Holtdale Approach, Leeds, LS16 7RX', 'B86004', 1, 5),
    ('Moor Grange, 60 Moor Grange View, Leeds, LS16 5BJ', 'B86065', 2, 5),
    ('New Road Side Surgery, 127 New Road Side, Leeds, LS18 4QD', 'B86628', 3, 5);

INSERT INTO `outreach_patient_access`.`referrers` (`name`, `national_code`,
    `referral_type_id`) VALUES
    ('KITCHEN CA', 'G8514138', 3),
    ('MANCHESTER K', 'G3200140', 3),
    ('CHANDAR NV', 'G8543918', 3);

INSERT INTO `outreach_patient_access`.`patients` (`last_name`, `first_name`, `dob`, `gender`,
    `nhs_number`, `created_at`) VALUES
    ('melon', 'walter', '1940-01-01', 'M', 1111111111, NOW()),
    ('case', 'justin',  '1930-01-01', 'M', 2222222222, NOW()),
    ('cart', 'orsen',   '1950-01-01', 'M', 3333333333, NOW()),
    ('nutt', 'hazel',   '1960-01-01', 'F', 4444444444, NOW()),
    ('shore', 'sandy',  '1920-01-01', 'F', 5555555555, NOW()),
    ('petal', 'rose',   '1930-01-01', 'F', 6666666666, NOW());

INSERT INTO `outreach_patient_access`.`patient_case` (`patient_id`, `referral_source_id`,
    `unit_number`) VALUES
    (1, 1, 112233),
    (2, 2, 223344),
    (3, 3, 334455),
    (4, 1, 445566),
    (5, 2, 556677),
    (6, 3, 667788);

INSERT INTO `outreach_patient_access`.`patient_access` (`patient_id`, `email`, `password`,
    `last_login`) VALUES
    (1, 'user1@email.net', 's9qne0wEqVUbh4HQMZH+CY8yXmc', '1900-01-01 00:00:00'),
    (2, 'user2@email.net', 'oYgcBu7JbbmQHHu/5BxCo/COnLQ', '1900-01-01 00:00:00'),
    (3, 'user3@email.net', 'C3+ElEbTODVG0VpICWYIRELNIZM', '1900-01-01 00:00:00'),
    (4, 'user4@email.net', 'Bubu9q3y5fVOpsQ8N21tNmBfgQ4', '1900-01-01 00:00:00'),
    (5, 'user5@email.net', 'fREmgbjdgHI4cah/9QYoZhP6nPY', '1900-01-01 00:00:00'),
    (6, 'user6@email.net', 'MSpG3FIRfvpOMJbtpRA3DwHIOyc', '1900-01-01 00:00:00');

INSERT INTO `outreach_patient_access`.`patient_demographics` (`patient_id`, `address`,
    `post_code`, `contact_number`, `gp_id`, `practice_id`) VALUES
    (1, '1 The Green, Leeds', 'LS16 2AA', '0777 111 2222', 1, 1),
    (2, '2 The Green, Leeds', 'LS16 2AA', '0777 111 3333', 2, 2),
    (3, '3 The Green, Leeds', 'LS16 2AA', '0777 111 4444', 3, 3),
    (4, '4 The Green, Leeds', 'LS16 2AA', '0777 111 5555', 1, 1),
    (5, '5 The Green, Leeds', 'LS16 2AA', '0777 111 6666', 2, 2),
    (6, '6 The Green, Leeds', 'LS16 2AA', '0777 111 7777', 3, 3);

INSERT INTO `outreach_patient_access`.`patient_dispatch_detail` (`patient_id`, `dispatch_to`) VALUES
    (1, 'home'),
    (2, 'home'),
    (3, 'home'),
    (4, 'home'),
    (5, 'home'),
    (6, 'home');

INSERT INTO `outreach_patient_access`.`status_options` (`description`) VALUES
    ('new'), ('screened'), ('reported'), ('authorised'), ('complete');

INSERT INTO `outreach_patient_access`.`lab_params` (`param_name`, `field_label`,
    `field_type`, `department_id`) VALUES
    ('sodium', 'Sodium', 'int', 3),
    ('potassium', 'Potassium', 'decimal', 3),
    ('creatinine', 'Creatinine', 'int', 3),
    ('urea', 'Urea', 'decimal', 3),
    ('alk_phos', 'AlkPhos', 'int', 3),
    ('albumin', 'Albumin', 'int', 3),
    ('calcium', 'Calcium', 'decimal', 3),
    ('phosphate', 'Phosphate', 'decimal', 3),
    ('total_protein', 'Protein', 'int', 3),
    ('wbc', 'WBC', 'decimal', 2),
    ('hb', 'Hb', 'int', 2),
    ('plts', 'Plts', 'int', 2),
    ('lymphs', 'Lymphs', 'decimal', 2),
    ('IgG', 'IgG', 'decimal', 1),
    ('IgA', 'IgA', 'decimal', 1),
    ('IgM', 'IgM', 'decimal', 1),
    ('paraprotein', 'Paraprotein', 'int', 1),
    ('electrophoresis', 'Electrophoresis', 'menu', 1),
    ('total_b_cells', 'B-cells', 'int', 4),
    ('kappa', 'B &kappa,+', 'int', 4),
    ('lambda', 'B &lambda,+', 'int', 4),
    ('sIg_neg', 'B sIg-', 'int', 4),
    ('cd5_pos', 'B CD5+', 'int', 4),
    ('neoplastic_b_cells', 'Neo B', 'int', 4),
    ('total_plasma_cells', "PC\'s", 'decimal', 4),
    ('cd19_neg_pc', 'CD19- PC', 'decimal', 4),
    ('globulin', 'Globulin', 'int', 1),
    ('bilirubin', 'Bilirubin', 'decimal', 3),
    ('alt', 'ALT', 'decimal', 3),
    ('magnesium', 'Magnesium', 'decimal', 3);


/* hilis4/outreach data */
INSERT INTO `outreach_patient_access`.`requests` (`id`, `request_number`, `year`,
    `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`)
    SELECT r.id, r.request_number, r.year, 1, 1, r.status_option_id, r.created_at
	FROM hilis4.requests r
	JOIN hilis4.patient_case pc on r.patient_case_id = pc.id
	JOIN ( hilis4.request_specimen rs JOIN hilis4.specimens s on rs.specimen_id = s.id )
		on rs.request_id = r.id
	WHERE pc.patient_id = 16600 AND s.sample_code = 'CMP';
    
INSERT INTO `outreach_patient_access`.`requests` (`id`, `request_number`, `year`,
    `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`)
    SELECT r.id, r.request_number, r.year, 2, 1, r.status_option_id, r.created_at
	FROM hilis4.requests r
	JOIN hilis4.patient_case pc on r.patient_case_id = pc.id
	JOIN ( hilis4.request_specimen rs JOIN hilis4.specimens s on rs.specimen_id = s.id )
		on rs.request_id = r.id
	WHERE pc.patient_id = 49144 AND s.sample_code = 'CMP';
/* screened */
INSERT INTO `outreach_patient_access`.`requests` (`id`, `request_number`, `year`,
    `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`)
    SELECT r.id, r.request_number, r.year, 3, 1, r.status_option_id, r.created_at
	FROM hilis4.requests r
	JOIN hilis4.patient_case pc on r.patient_case_id = pc.id
	JOIN ( hilis4.request_specimen rs JOIN hilis4.specimens s on rs.specimen_id = s.id )
		on rs.request_id = r.id
	WHERE pc.patient_id = 45916 AND s.sample_code = 'CMP';
/* new */
INSERT INTO `outreach_patient_access`.`requests` (`id`, `request_number`, `year`,
    `patient_case_id`, `referrer_department_id`, `status_option_id`, `created_at`)
    VALUES(255352, 10937, 2015, 4, 1, 1, '2015-05-13 08:00:21');

INSERT INTO `outreach_patient_access`.`request_followup` (`request_id`, `followup_option_id`,`time`)
    SELECT r.id, rfu.followup_option_id, rfu.time
	FROM outreach_patient_access.requests r
	JOIN outreach_patient_access.patient_case pc on r.patient_case_id = pc.id
	JOIN outreach.request_followup rfu on rfu.request_id = r.id;

INSERT INTO outreach_patient_access.request_pack_dispatch(request_id,pack_due,pack_sent,return_due,time)
   SELECT r.id, rpd.pack_due, rpd.pack_sent, rpd.return_due, rpd.time
	FROM outreach_patient_access.requests r
	JOIN outreach.request_pack_dispatch rpd on rpd.request_id = r.id
	JOIN outreach_patient_access.patient_case pc on r.patient_case_id = pc.id;
    