use Test::More;

use AppTest;
use Template;
use Modern::Perl;
use Data::Printer alias => 'p';
use HTML::TreeBuilder::XPath;

use constant TMPL => 'packs.tt';

require_ok( 'AppTest' ); # Data::Printer, Moo, etc

my $app = AppTest->new;
my $tt  = Template->new( { INCLUDE_PATH => $app->config->{appdir} . '/views' } );

my @patients = $app->model->dbix->select('patients', 'id')->column; # p \@patients;

for my $id (@patients) { # last if $id > 1392;
    my $vars = $app->model->get_outreach_data($id); # p $vars;
    my $content;
    
    # process input template, substituting variables
    $tt->process(TMPL, { data => $vars }, \$content) || die $tt->error(); # p $content;
    
    my $tree = HTML::TreeBuilder->new_from_content($content); # p $tree; exit;
    # content of 'Your current pack status' div:
    my $status = $tree->findvalue( '//div[@class="panel-body"]/span');
    
    next unless $status =~ /UNKNOWN RECORD STATUS/;
    say $id, ': ', $status;    
}

done_testing(1);
