package Routes;

=begin # to force Email::Sender transport:
  export MY_EMAIL_SENDER_TRANSPORT=SMTP
  export MY_EMAIL_SENDER_TRANSPORT=Test
  export MY_EMAIL_SENDER_TRANSPORT=MBox
=cut

use Dancer2;
# use Dancer2::Plugin::Email; # needs all msg construction in route
use Dancer2::Plugin::Database;

use Model;
use Data::Printer;

our $VERSION = '0.1';

# for routes that just return a template of same name:
set auto_page => 1; # eg /login, /edit_details

my $model = Model->new( dbh => database(), app_config => config() ); # or:
# sub dbix { DBIx::Simple->new( database() ) }

# hooks =========================================================================
hook before => sub {
    # all routes need authenticated session (except /login request):
    unless ( session 'user' ) {
        my $request_path = request->path_info; # p $request_path;
        redirect '/login' unless grep $request_path eq '/'.$_, qw(login index);
    }
};

# routes =======================================================================
get '/' => sub {
    my $user = session 'user';
    my $data = $model->get_outreach_data($user->{nhs_number}); # p $data;
    template welcome => { data => $data  }; # data = href of packs & results
};

post '/login' => sub {
    my $params = params; # p $params;

    # validate login (returns user profile or empty):
    if ( my $user = $model->authenticate_user($params) ) { # p $user;
        session user => $user;
        redirect '/';
    }
    else {
        template login => { error => 'invalid username or password' };
    }
};

post '/ajax_amend_details' => sub {
    # email web-form to admin, return acknowlegement - after 7 days, etc
    my $session = session->read('user'); # p $session;
    my $params  = params; # p $params;

    { # validate passwords match:
        my $result = $model->validate_password($params, $session);
        if ( my $err = $result->{errors}) { # p $err; # href of error(s)
            my $json = to_json({ success => undef, errors => $err });
            return $json;
        }
    }
    { # send email to admin:
        my $result = $model->email_patient_demographics($params, $session);
        if ( my $err = $result->{errors}) { # p $err; # href of error(s)
            return to_json({ success => undef, errors => $err });
        }
        else {
            return to_json({ success => 1, message => $result->{msg} });
        }
    }
};

get '/logout' => sub {
    app->destroy_session;
    redirect('/'); # should redirect to /login
};

# original index page:
get '/index' => sub { template index => {}, { layout => 'index' } };

#==============================================================================
# my $foo = dbix->query('select * from users where id = ?', 14)->hash; p $foo;
# my $bar = $model->get_data('select * from users limit 2'); p $bar;
# my $baz = $model->get_data('select count(*) as count from users'); p $baz;
# my $bap = database->quick_select('users', { id => 10}); p $bap;
# my $dax = database->quick_count('users', {}); p $dax;

true;
