use strict;
use warnings;

use Routes;
use Test::More tests => 3;
use Plack::Test;
use HTTP::Request::Common;

my $app = Routes->to_app;
is( ref $app, 'CODE', 'Got app' );

my $test = Plack::Test->create($app);
{
    my $res = $test->request( GET '/' );
    ok( $res->is_redirect, '[GET /] redirect' );
}
{
    my $res = $test->request( GET '/login' ); # warn $res->content;
    ok( $res->is_success, '[GET /login] successful' );
}