package AppTest;

use Model;
use Config::Any;
use Data::Printer;
use FindBin qw($Bin);
use Moo;

$ENV{SQL_TRACE} = 0;

has model => (
    is => 'ro',
    builder => sub { Model->new( app_config => shift->config ) },
);
has config => ( is => 'lazy' );

sub _build_config {
=begin # doesn't return appdir:
    my @files = (
        $Bin . '/../config.yml'
        $Bin . '/../environments/test.yml',
    );
    my $cfg = Config::Any->load_files( { files => \@files } ); p $cfg;
=cut
    my $cfg = { # required params from config.yml:
        db_name => 'outreach_patient_access',
        appdir  => $Bin . '/..',
    }; # p $cfg;
    return $cfg;
}

1;
