package Routes;

=begin
  # to force Email::Sender transport:
  export MY_EMAIL_SENDER_TRANSPORT=SMTP
  export MY_EMAIL_SENDER_TRANSPORT=Test
  export MY_EMAIL_SENDER_TRANSPORT=MBox

  dev box MTA for smtp is exim4; useful commands:
    sudo mailq
    tail -f /var/log/exim4/mainlog
=cut

use Dancer2;
# use Dancer2::Plugin::Email; # needs all msg construction to be done in route
use Dancer2::Plugin::Database;

use Model;
use Data::Printer;

our $VERSION = '0.1';

# for routes that just return a template of same name:
set auto_page => 1; # eg /login

my $model = Model->new( dbh => database(), app_config => config() ); # or:
# sub dbix { DBIx::Simple->new( database() ) }

# hooks =========================================================================
hook before => sub {
    # all routes need authenticated session (except /login request):
    unless ( session 'user' ) {
        my $request_path = request->path_info; # p $request_path;
        redirect '/login' unless grep $request_path eq '/'.$_, qw(login index);
    }
};

hook before_template_render => sub {
    my $tokens = shift;
    $tokens->{app_version} = $model->version;
};

# routes =======================================================================
get '/' => sub {
    my $user = session 'user';
    my $data = $model->get_outreach_data($user->{nhs_number}); # p $data;
    template welcome => { data => $data  }; # data = href of packs & results
};

post '/login' => sub {
    my $params = params; # p $params;

    # validate login (returns user profile or empty):
    if ( my $user = $model->authenticate_user($params) ) { # p $user;
        session user => $user;
        redirect '/';
    }
    else {
        template login => { error => 'invalid username or password' };
    }
};

post '/ajax_amend_details' => sub { # email web-form to admin:
    my $session = session->read('user'); # p $session;
    my $params  = params; # p $params;

    { # validate web-form password matches session passwd:
        my $result = $model->validate_password($params, $session);
        if ( my $err = $result->{errors}) { # p $err; # href of error(s)
            my $json = to_json({ success => undef, errors => $err });
            return $json;
        }
    }
    { # passwords OK, send email to admin:
        my $result = $model->email_patient_demographics($params, $session);
        if ( my $err = $result->{errors}) { # p $err; # href of error(s)
            return to_json({ success => undef, errors => $err });
        }
        # ok, no error, return good news:
        return to_json({ success => 1, message => $result->{msg} });
    }
};

# not used for demo:
get '/view_report' => sub {
    # send SHA-encoded nhs_number from session to HILIS4 get_outreach_patient_access_report();
    # SHA-encoded as 1) it's transmitted through internet b) to prevent tampering
    my $sql = q!SELECT MAX(t1.id) from hilis4.authorised_reports_view t1
    JOIN ( request_specimen rs join specimens s on rs.specimen_id = s.id )
        on rs.request_id = t1.id
    WHERE nhs_number = sha($session.nhs_number)
        and s.sample_code = 'CMP'!; # to exclude non-outreach requests
};

get '/logout' => sub {
    app->destroy_session;
    redirect('/'); # should redirect to /login
};

get '/gitlog' => sub { template gitlog => { log => $model->gitlog } };

# original index page:
get '/index' => sub { template index => {}, { layout => 'index' } };

#==============================================================================
# my $foo = dbix->query('select * from users where id = ?', 14)->hash; p $foo;
# my $bar = $model->get_data('select * from users limit 2'); p $bar;
# my $baz = $model->get_data('select count(*) as count from users'); p $baz;
# my $bap = database->quick_select('users', { id => 10}); p $bap;
# my $dax = database->quick_count('users', {}); p $dax;

true;
