package Routes;

use Dancer2;
use Dancer2::Plugin::Database;

use Model;
use Data::Printer;

our $VERSION = '0.1';

set auto_page => 1; # /login

my $model = Model->new( dbh => database() ); # or:
# sub dbix { DBIx::Simple->new( database() ) } # uses D::P::Database handle

hook before => sub {
    # all routes need authenticated session (except /login request):
    unless ( session('logged_in') ) {
        redirect '/login' unless request->path_info =~ m!^/(login|index)$!;
    }
};

get '/' => sub {
    # my $user = $model->get_data('select * from users where id = ?', 14); p $user;
    template welcome => {};
};

# get '/login' => sub { template 'login' }; # delivered using auto_page()
post '/login' => sub {
    my $params = params; # p $params;

    # validate login:
    if ( $model->authenticate_user($params) ) { # p $user;
        session logged_in => 1;
        redirect '/';
    }
    else {
        template login => { error => 'invalid username or password' };
    }
};

get '/logout' => sub {
    app->destroy_session;
    redirect('/'); # should redirect to /login
};

# original index page:
get '/index' => sub { template index => {}, { layout => 'index' } };

#==============================================================================
# my $foo = dbix->query('select * from users where id = ?', 14)->hash; p $foo;
# my $bar = $model->get_data('select * from users limit 2'); p $bar;
# my $baz = $model->get_data('select count(*) as count from users'); p $baz;

true;
