INSERT INTO `outreach`.`followup_options` (`option`, `label`) VALUES
    ('zero_month', 'immediately'),
    ('one_month', 'one month'),
    ('three_month', 'three months'),
    ('six_month', 'six months'),
    ('twelve_month', 'twelve months'),
    ('clinic_return', 'return to clinic'),
    ('dead', 'dead'),
    ('other', 'other'),
    ('twenty_four_month', 'two years'),
    ('sixty_month', 'five years');

INSERT INTO `outreach`.`result_types` (`description`) VALUES
    ('immunology'),
    ('haematology'),
    ('biochemistry'),
    ('flow_cytometry');

INSERT INTO `hilis4`.`referral_sources` (`display_name`, `organisation_code`,
    `parent_organisation_id`, `referral_type_id`) VALUES
    ('Highfield Surgery, Holtdale Approach, Leeds, LS16 7RX', 'B86004', 1, 5),
    ('Moor Grange, 60 Moor Grange View, Leeds, LS16 5BJ', 'B86065', 2, 5),
    ('New Road Side Surgery, 127 New Road Side, Leeds, LS18 4QD', 'B86628', 3, 5);

INSERT INTO `hilis4`.`referrers` (`name`, `national_code`, `referral_type_id`) VALUES
    ('KITCHEN CA', 'G8514138', 3),
    ('MANCHESTER K', 'G3200140', 3),
    ('CHANDAR NV', 'G8543918', 3);

INSERT INTO `hilis4`.`patients` (`last_name`, `first_name`, `dob`, `gender`,
    `nhs_number`) VALUES
    ('melon', 'walter', '1940-01-01', 'M', 1111111111),
    ('case', 'justin',  '1930-01-01', 'M', 2222222222),
    ('cart', 'orsen',   '1950-01-01', 'M', 3333333333),
    ('nutt', 'hazel',   '1960-01-01', 'F', 4444444444),
    ('shore', 'sandy',  '1920-01-01', 'F', 5555555555),
    ('petal', 'rose',   '1930-01-01', 'F', 6666666666);

INSERT INTO `hilis4`.`patient_case` (`patient_id`, `referral_source_id`, `unit_number`) VALUES
    (1, 1, 112233),
    (2, 2, 223344),
    (3, 3, 334455),
    (4, 1, 445566),
    (5, 2, 556677),
    (6, 3, 667788);

INSERT INTO `outreach`.`patient_access` (`patient_id`, `email`, `password`, `last_login`) VALUES
    (1, 'user1@email.net', 'ieSV55Qc+eQOaYDRSha/AjzNTJE', '1900-01-01 00:00:00'),
    (2, 'user2@email.net', 'ieSV55Qc+eQOaYDRSha/AjzNTJE', '1900-01-01 00:00:00'),
    (3, 'user3@email.net', 'ieSV55Qc+eQOaYDRSha/AjzNTJE', '1900-01-01 00:00:00'),
    (4, 'user4@email.net', 'ieSV55Qc+eQOaYDRSha/AjzNTJE', '1900-01-01 00:00:00'),
    (5, 'user5@email.net', 'ieSV55Qc+eQOaYDRSha/AjzNTJE', '1900-01-01 00:00:00'),
    (6, 'user6@email.net', 'ieSV55Qc+eQOaYDRSha/AjzNTJE', '1900-01-01 00:00:00');

INSERT INTO `hilis4`.`patient_demographics` (`patient_id`, `address`, `post_code`,
    `contact_number`, `gp_id`, `practice_id`) VALUES
    (1, '1 The Green, Leeds', 'LS16 2AA', '0777 111 2222', 1, 1),
    (2, '2 The Green, Leeds', 'LS16 2AA', '0777 111 3333', 2, 2),
    (3, '3 The Green, Leeds', 'LS16 2AA', '0777 111 4444', 3, 3),
    (4, '4 The Green, Leeds', 'LS16 2AA', '0777 111 5555', 1, 1),
    (5, '5 The Green, Leeds', 'LS16 2AA', '0777 111 6666', 2, 2),
    (6, '6 The Green, Leeds', 'LS16 2AA', '0777 111 7777', 3, 3);

INSERT INTO `outreach`.`patient_dispatch_detail` (`patient_id`, `dispatch_to`) VALUES
    (1, 'home'),
    (2, 'home'),
    (3, 'home'),
    (4, 'home'),
    (5, 'home'),
    (6, 'home');

INSERT INTO `hilis4`.`requests` (`request_number`, `year`, `patient_case_id`,
    `referrer_department_id`, `status_option_id`) VALUES
    (1, '2015', 1, 1, 5),
    (2, '2015', 1, 1, 5),
    (3, '2015', 2, 1, 5),
    (4, '2015', 2, 1, 5),
    (5, '2015', 3, 1, 5),
    (6, '2015', 3, 1, 5),
    (7, '2015', 3, 1, 5),
    (8, '2015', 4, 1, 5),
    (9, '2015', 4, 1, 5),
    (10, '2015', 4, 1, 5),
    (11, '2015', 4, 1, 5),
    (12, '2015', 5, 1, 5),
    (13, '2015', 5, 1, 5),
    (14, '2015', 6, 1, 5),
    (15, '2015', 6, 1, 5),
    (16, '2015', 6, 1, 5);

INSERT INTO `outreach`.`lab_params` (`param_name`, `field_label`, `field_type`, `department_id`) VALUES
    ('sodium', 'Sodium', 'int', 3),
    ('potassium', 'Potassium', 'decimal', 3),
    ('creatinine', 'Creatinine', 'int', 3),
    ('urea', 'Urea', 'decimal', 3),
    ('alk_phos', 'AlkPhos', 'int', 3),
    ('albumin', 'Albumin', 'int', 3),
    ('calcium', 'Calcium', 'decimal', 3),
    ('phosphate', 'Phosphate', 'decimal', 3),
    ('total_protein', 'Protein', 'int', 3),
    ('wbc', 'WBC', 'decimal', 2),
    ('hb', 'Hb', 'int', 2),
    ('plts', 'Plts', 'int', 2),
    ('lymphs', 'Lymphs', 'decimal', 2),
    ('IgG', 'IgG', 'decimal', 1),
    ('IgA', 'IgA', 'decimal', 1),
    ('IgM', 'IgM', 'decimal', 1),
    ('paraprotein', 'Paraprotein', 'int', 1),
    ('electrophoresis', 'Electrophoresis', 'menu', 1),
    ('total_b_cells', 'B-cells', 'int', 4),
    ('kappa', 'B &kappa,+', 'int', 4),
    ('lambda', 'B &lambda,+', 'int', 4),
    ('sIg_neg', 'B sIg-', 'int', 4),
    ('cd5_pos', 'B CD5+', 'int', 4),
    ('neoplastic_b_cells', 'Neo B', 'int', 4),
    ('total_plasma_cells', 'PC\'s', 'decimal', 4),
    ('cd19_neg_pc', 'CD19- PC', 'decimal', 4),
    ('globulin', 'Globulin', 'int', 1),
    ('bilirubin', 'Bilirubin', 'decimal', 3),
    ('alt', 'ALT', 'decimal', 3),
    ('magnesium', 'Magnesium', 'decimal', 3);
