package Model;

use SQL::Library;
use DBIx::Simple;
use Digest::SHA1;
use Data::Printer;
use DateTime::Format::MySQL;

use Moo;
# required items for constructor:
has $_ => ( is => 'ro', required => 1 ) for qw(dbh app_config); # appdir, environment, etc
has dbix => ( is => 'lazy', builder => sub { DBIx::Simple->new(shift->dbh) } );
has sql_lib => ( is => 'lazy' ); # _build_sql_lib()

sub authenticate_user {
    my ($self, $params) = @_; # p $params;

    my $sql  = $self->sql_lib->retr('user_details'); # p $sql;
    my $user = $self->_query($sql, $params->{username})
        || return 0; # p $user;

# don't need authenticated login for dev env:
    unless ( $self->app_config->{environment} eq 'development' ) {
        # check SHA1 b64digest 'password' param matches patient_access.password:
        my $digest = _sha1_digest($params->{password}); # p $digest;
        return 0 unless $user->{password} eq $digest;
    }

# update last_login date:
    my $now = 'NOW()'; # DateTime->now( time_zone => 'Europe/London' );
    $self->dbix->update( 'outreach.patient_access',
        { last_login => \$now },
        { patient_id => $user->{patient_id} },
    );

    return $user;
}

sub get_outreach_data {
    my ($self, $user) = @_; # p $user;
    my $id = $user->{nhs_number};
    # pack dispatches, results, etc:
    return {};
}

# private subs =================================================================
sub _query {
    my $self = shift;
    my ($sql, @bind) = @_; # p $sql; p @bind;

    my $data = $self->dbix->query($sql, @bind)->hashes; # p $data;
    _autoinflate_dates($data);

    # return ref to array of hashrefs or single hashref:
    return @$data > 1
        ? $data # AoH
        : $data->[0]; # href
}

#-------------------------------------------------------------------------------
# if it looks like a MySQL date or date + time, inflate to DateTime object:
sub _autoinflate_dates {
    my $data = shift;

    my $re = qr!\d{4}-\d{2}-\d{2}(\s\d{2}:\d{2}:\d{2})?!;

    my $to_datetime = sub {
        my $val = shift || return; # p $val;
        if ( my ($date) = $val =~ m!\A($re)\Z! ) { # p $date;
            $val = length $date > 10 # ie date + time
                ? DateTime::Format::MySQL->parse_datetime($date)
                : DateTime::Format::MySQL->parse_date($date);
        }
        return $val;
    };

    for my $ref(@$data) {
       $ref->{$_} = &$to_datetime($ref->{$_}) for keys %$ref;
    }
}

#-------------------------------------------------------------------------------
sub _sha1_digest {
	my $str = shift; # p $str;

    my $sha1 = Digest::SHA1->new;
    $sha1->add($str);

    return $sha1->b64digest;
}

#-------------------------------------------------------------------------------
sub _build_sql_lib {
    my $lib = shift->app_config->{appdir} . '/src/queries.sql';
    SQL::Library->new({ lib => $lib });
};

=begin
sub _build_dbix { # warn 'building dbix object';
    my $dsn = 'dbi:mysql:database=hilis4;mysql_read_default_file=~/.local/mysql.cnf';
    DBIx::Simple->connect($dsn);
}
=cut

1;
