# 2 exons, 2 different samples:

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    [
        'N-Ras exon 3.1',
        '233:T/A',
        'Accepted',
        51.1, 66,
        0, 66,
        51.1, 66,
    ],
    [
        'RUNX exon 4.1',
        '102:C/T',
        'Accepted',
        13.2, 66,
        13.2, 66,
        0, 66,
    ],
);
# ==============================================================================

my $content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @$content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

like( $response->content, qr(N-Ras exon 3.1 \[233:T/A\]) );
like( $response->content, qr(RUNX exon 4.1 \[102:C/T\]) );
like( $response->content, qr(Processed 2 vep input rows) );
like( $response->content, qr(Sample results for data src "data.txt" \[2\]) );
like( $response->content, qr(Sample match failures \[0\]) );
like( $response->content, qr(VEP results \[9\]) );
like( $response->content, qr(Non-CDS VEP results \[0\]) );

done_testing;