CREATE TABLE `non_cds` (
	`id` VARCHAR(50) NOT NULL,
	`exon_id` VARCHAR(255) NOT NULL,
	`chromosome` CHAR(2) NOT NULL,
	`start_point` INT(11) NOT NULL,
	`end_point` INT(11) NOT NULL,
	`allele` VARCHAR(25) NOT NULL,
	`datetime` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
)
COMMENT='processed non-CDS output data for download'
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
;

CREATE TABLE `vep_data` (
	`id` VARCHAR(50) NOT NULL,
	`exon_ref` VARCHAR(255) NOT NULL,
	`chromosome` CHAR(2) NOT NULL,
	`start_point` INT(11) NOT NULL,
	`end_point` INT(11) NOT NULL,
	`allele` VARCHAR(25) NOT NULL,
	`gene` VARCHAR(50) NOT NULL,
	`feature` VARCHAR(50) NOT NULL,
	`consequence` VARCHAR(255) NOT NULL,
	`cds` VARCHAR(50) NOT NULL,
	`protein` VARCHAR(10) NOT NULL,
	`aa` VARCHAR(15) NOT NULL,
	`existing_variation` TEXT NULL,
	`sift` VARCHAR(50) NULL DEFAULT '-',
	`polyphen` VARCHAR(50) NULL DEFAULT '-',
	`extra` VARCHAR(255) NOT NULL,
	`datetime` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
)
COMMENT='processed VEP output data for download'
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
;

CREATE TABLE `sample_data` (
	`id` VARCHAR(50) NOT NULL,
	`request_number` SMALLINT(6) NOT NULL,
	`year` YEAR NOT NULL,
	`exon_ref` VARCHAR(255) NOT NULL,
	`vep_no` CHAR(2) NOT NULL,
	`freq` VARCHAR(15) NOT NULL,
	`af` DOUBLE(4,3) NOT NULL,
	`depth` SMALLINT(6) NOT NULL,
	`filter` VARCHAR(10) NOT NULL,
	`consequence` VARCHAR(255) NULL DEFAULT NULL,
	`cds` VARCHAR(50) NULL DEFAULT NULL,
	`protein` VARCHAR(50) NULL DEFAULT NULL,
	`existing_variation` TEXT NULL,
	`sift` VARCHAR(50) NULL DEFAULT '-',
	`polyphen` VARCHAR(50) NULL DEFAULT '-',
	`datetime` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
)
COMMENT='processed sample output data for download'
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
;
