# tests $filename file upload

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

my $filename = 'single.vcf';
my @content = content_with_static_file($filename); # can return either array, or arrayref

say '###################################';
say "this test may take some time .....";
say '###################################';

my $response = $test->request( POST '/vep', @content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

like( $response->content, qr(@_) ) for (
    "Sample results for data src \"$filename\" [5]",
    'Processed 1 vep input rows',
    '1 accepted/filtered rows',
    '1 total source file rows',
    'sample match failures [0]',
    'VEP results [7]',
    'non-CDS [0]',
);

done_testing;
