# tests _want_vep_result() logic:

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = ( # synonymous_variant + variation =~ COSM*
    [
        'p53 exon 6.2 NEW',
        '137:T/C',
        'Accepted',
        100, 8,
        4.94, 81,
    ],
);
# ==============================================================================

my $content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @$content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

# result = 'match' on COSM:
check_response( $response->content, 'p53 exon 6.2 NEW \[137:T/C\]' ); 
check_response( $response->content, 'Processed 1 vep input rows' );
check_response( $response->content, 'Sample results for data src "data.txt" \[1\]' );
check_response( $response->content, 'Sample match failures \[0\]' );
check_response( $response->content, 'VEP results \[8\]' );
check_response( $response->content, 'Non-CDS VEP results \[0\]' );
check_response( $response->content, 'synonymous_variant' );

{ # substitute WT exon 7.2 [177:G/C] - stop_gained with variation = '-':
    $test_data[0][0] = 'WT exon 7.2';
    $test_data[0][1] = '177:G/C'; # warn Dumper \@test_data;
    my @content = create_content(\@test_data); # as array to distinguish from $content
    
    # result = 'match' on var = '-' & consequence not synonymous_variant
    my $response = $test->request( POST '/vep', @content ); # print_output($response);
    is( $response->code, 200, '[POST /vep] success' ); # exit;
    
    check_response( $response->content, 'Sample results for data src "data.txt" \[1\]' );
    check_response( $response->content, 'Sample match failures \[0\]' );
    check_response( $response->content, 'VEP results \[7\]' );
}
{ # substitute WT exon 7.2 [177:G/A] - synonymous_variant with variation = '-':
    $test_data[0][0] = 'WT exon 7.2';
    $test_data[0][1] = '177:G/A'; # warn Dumper \@test_data;
    my @content = create_content(\@test_data);
    
    my $response = $test->request( POST '/vep', @content ); # print_output($response);
    is( $response->code, 200, '[POST /vep] success' ); # exit;
    
    # result = 'no match' on consequence = synonymous_variant
    check_response( $response->content, 'WT exon 7.2 \[177:G/A\]' );
    check_response( $response->content, 'Sample results for data src "data.txt" \[0\]' );
    check_response( $response->content, 'Sample match failures \[1\]' );
    check_response( $response->content, 'VEP results \[7\]' );
}

{ # substitute ASXL exon 12.2 [157:G/A] - missense_variant with variation =~ 'rs*':
    $test_data[0][0] = 'ASXL exon 12.2';
    $test_data[0][1] = '157:G/A'; # warn Dumper \@test_data;
    my @content = create_content(\@test_data);
    
    my $response = $test->request( POST '/vep', @content ); # print_output($response);
    is( $response->code, 200, '[POST /vep] success' ); # exit;
    
    # result = 'no match' on variation not one of COSM*, TMP* or '-'
    check_response( $response->content, 'ASXL exon 12.2 \[157:G/A\]' );
    check_response( $response->content, 'Sample results for data src "data.txt" \[0\]' );
    check_response( $response->content, 'Sample match failures \[1\]' );
    check_response( $response->content, 'VEP results \[2\]' );
}

{ # substitute IDH 1.1 [146:G/A] - synonymous_variant with variation =~ 'rs*':
    $test_data[0][0] = 'IDH 1.1';
    $test_data[0][1] = '146:G/A'; # warn Dumper \@test_data;
    my @content = create_content(\@test_data);
    
    my $response = $test->request( POST '/vep', @content ); # print_output($response);
    is( $response->code, 200, '[POST /vep] success' ); # exit;
    
    # result = 'no match' on synonymous_variant and not COSM*
    check_response( $response->content, 'IDH 1.1 \[146:G/A\]' );
    check_response( $response->content, 'Sample results for data src "data.txt" \[0\]' );
    check_response( $response->content, 'Sample match failures \[1\]' );
    check_response( $response->content, 'VEP results \[4\]' );
}

# NB: global $response gets replaced in each block !!
sub check_response {
    my ($content, $pattern) = @_;    
    like( $content, qr($pattern) );
}

done_testing;