# multiple point mutations at same location:

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    [
        'N-Ras exon 2.1',
        '141:C/G',
        'Accepted',
        6.5, 446,
        6.5, 446,
    ],
    [
        'N-Ras exon 2.1',
        '141:C/T',
        'Accepted',
        50.83, 120,
        50.83, 120,
    ],
);
# ==============================================================================

my $content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @$content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

like( $response->content, qr{N-Ras exon 2.1 \[141:C/G\]} ); 
like( $response->content, qr{N-Ras exon 2.1 \[141:C/T\]} ); 
like( $response->content, qr{Processed 2 vep input rows} );
like( $response->content, qr{Sample results for data src "data.txt" \[2\]} );
like( $response->content, qr{Sample match failures \[0\]} );
like( $response->content, qr{VEP results \[2\]} );
like( $response->content, qr{Non-CDS VEP results \[0\]} );

done_testing;