# sample match failure (synonymous_variant = rejected):

use NGS::Test::Common; # imports all required modules (NGS, Plack::Test, etc)

my $app = NGS->to_app;
my $test = Plack::Test->create($app);

# test data ====================================================================
my @test_data = (
    [
        'p53 exon 9.5 NEW',
        '120:T/C',
        'Accepted',
        11.66, 163,
        11.66, 163,
    ],
);
# ==============================================================================

my $content = create_content(\@test_data); # can return either array, or arrayref
my $response = $test->request( POST '/vep', @$content ); # print_response($response);
is( $response->code, 200, '[POST /vep] success' );

# p53 exon 9.5 NEW [120]
like( $response->content, qr{p53 exon 9.5 NEW \[120:T/C\]} );
like( $response->content, qr{Processed 1 vep input rows} );
like( $response->content, qr{synonymous_variant} );
like( $response->content, qr{Sample results for data src "data.txt" \[0\]} );
like( $response->content, qr{Sample match failures \[1\]} );
like( $response->content, qr{VEP results \[7\]} );
like( $response->content, qr{Non-CDS VEP results \[0\]} );

done_testing;